/*
 * Copyright (c) 2019 huipei.x
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.xphsc.xpack.utils;

import org.apache.maven.plugin.logging.Log;

/**
 * @author <a href="xiongpeih@163.com">huipei.x</a>
 * @description:
 * @since 1.0.0
 */
public final class Logger {


    private static Log log;


    private Logger() {}


    public static synchronized void initSetLog(Log mvnLog) {
        log = mvnLog;
    }

    /**
     * 打印 debug 日志.
     *
     * @param content 日志内容
     */
    public static void debug(CharSequence content) {
        log.debug(content);
    }

    /**
     * 打印 info 日志.
     *
     * @param content 日志内容
     */
    public static void info(CharSequence content) {
        log.info(content);
    }

    /**
     * 打印 warn 日志.
     *
     * @param content 日志内容
     */
    public static void warn(CharSequence content) {
        log.warn(content);
    }

    /**
     * 打印 error 日志信息.
     *
     * @param content 日志内容
     */
    public static void error(CharSequence content) {
        log.error(content);
    }

    /**
     * 打印 error 日志和 Throwable 堆栈信息.
     *
     * @param content 日志内容
     * @param error Throwable对象
     */
    public static void error(CharSequence content, Throwable error) {
        log.error(content, error);
    }

}
