/*
 * Copyright (c) 2019 huipei.x
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.xphsc.xpack.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.codehaus.plexus.util.FileUtils;

/**
 * @author <a href="xiongpeih@163.com">huipei.x</a>
 * @description:
 * @since 1.0.0
 */
public final class Templates {

    private Templates() {}


    private static GroupTemplate groupTemplate;

    static {

        try {
            Configuration cfg = Configuration.defaultConfiguration();
            cfg.getResourceMap().put("autoCheck", "false");
            groupTemplate = new GroupTemplate(new ClasspathResourceLoader("/"), cfg);
        } catch (IOException e) {
            Logger.error("初始化 beetl 模版出错！", e);
        }
    }


    private static String render(String filePath, Map<String, Object> context) {
        Template template = groupTemplate.getTemplate(filePath);
        template.fastBinding(context);
        return template.render();
    }


    public static void renderFile(String template, Map<String, Object> context, String out) throws IOException {
        FileUtils.fileWrite(out, StandardCharsets.UTF_8.name(), Templates.render(template, context));
    }

}
