/*
 * Copyright (c) 2019 huipei.x
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.xphsc.xpack.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author <a href="xiongpeih@163.com">huipei.x</a>
 * @description:
 * @since 1.0.0
 */
public final class Times {


    static final String EMPTY = "";


    private Times() {}


    static String join(Object... objects) {
        if (objects != null && objects.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Object o : objects) {
                sb.append(o == null ? EMPTY : o.toString());
            }
            return sb.toString();
        }

        return EMPTY;
    }


    public static String convertTime(Number n) {
        double d = n.doubleValue();
        if (d < 1e5) {
            return Long.toString(n.longValue()).concat(" ns");
        } else if (d >= 1e4 && d < 1e9) {
            return getRoundString(d / 1e6, "ms");
        } else if (d >= 1e9 && d < 6e10) {
            return getRoundString(d / 1e9, "s");
        } else if (d >= 6e10 && d < 36e11) {
            return getRoundString(d / 6e10, "min");
        } else if (d >= 36e11 && d < 864e11) {
            return getRoundString(d / 36e11, "h");
        } else {
            return getRoundString(d / 864e11, "d");
        }
    }


    private static String getRoundString(double d, String unit) {
        return join(BigDecimal.valueOf(d)
                .setScale(2, RoundingMode.HALF_UP).doubleValue(), " ", unit);
    }

}