/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack;

import cn.xphsc.xpack.domain.CopyResource;
import cn.xphsc.xpack.domain.Docker;
import cn.xphsc.xpack.domain.Linux;
import cn.xphsc.xpack.domain.PackInfo;
import cn.xphsc.xpack.domain.SkipErrorEnum;
import cn.xphsc.xpack.domain.Windows;
import cn.xphsc.xpack.utils.Logger;
import cn.xphsc.xpack.utils.Times;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractMojoBuilder
extends AbstractMojo {
    private static final String START = "-------------------------- Xpack start packing... -------------------------\n___    ___                   __    \n\\   \\/  /__________    ____ |  | __\n \\     /\\____ \\__  \\ _/ ___\\|  |/ /\n /     \\|  |_> > __ \\\\  \\___|    < \n/___/\\  \\   __(____  /\\___  >__|_ \\\n      \\_/__|       \\/     \\/     \\/";
    static final String HOME_DIR_NAME = "xpack";
    private static final String JDK8_IMAGE = "jdk:8-jdk-alpine";
    private static final String[] DEFAULT_VOLUMES = new String[]{"/tmp", "logs"};
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File targetDir;
    @Parameter(defaultValue="${project.groupId}", required=true)
    private String groupId;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String artifactId;
    @Parameter(defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="false", property="nameVersion")
    private boolean nameVersion;
    @Parameter(defaultValue="${project.description}")
    private String description;
    @Parameter(property="vmOptions")
    private String vmOptions;
    @Parameter(property="programArgs")
    private String programArgs;
    @Parameter(property="configFiles")
    private String[] configFiles;
    @Parameter(property="platforms")
    protected String[] platforms;
    @Parameter(property="skipError")
    private String skipError;
    @Parameter(property="windows")
    private Windows windows;
    @Parameter(property="linux")
    private Linux linux;
    @Parameter(property="docker")
    private Docker docker;
    @Parameter(property="excludeFiles")
    private String[] excludeFiles;
    @Parameter(property="copyResources")
    private CopyResource[] copyResources;

    public void execute() {
        Logger.initSetLog(super.getLog());
        Logger.info(START);
        long start = System.nanoTime();
        this.exec();
        Logger.info("------------- xpack has been packaged to end. [costs: " + Times.convertTime(System.nanoTime() - start) + "] -------------\n");
    }

    protected abstract void exec();

    protected PackInfo buildPackInfo() {
        PackInfo packInfo = new PackInfo().setTargetDir(this.targetDir).setHomeDir(this.createHomeDir()).setArtifactId(this.artifactId).setVersion(this.version).setNameVersion(this.nameVersion).setName(this.finalName).setDescription(this.description).setVmOptions(this.vmOptions).setProgramArgs(this.programArgs).setConfigFiles(this.configFiles).setSkipError(SkipErrorEnum.of(this.skipError)).setWindows(this.windows).setLinux(this.linux).setDocker(this.initDefaultDockerInfo()).setExcludeFiles(this.excludeFiles).setCopyResources(this.copyResources);
        Logger.debug(packInfo.toString());
        return packInfo;
    }

    private File createHomeDir() {
        File file = new File(this.targetDir + File.separator + HOME_DIR_NAME + File.separator);
        try {
            if (file.exists()) {
                FileUtils.cleanDirectory((File)file);
            } else {
                FileUtils.forceMkdir((File)file);
            }
        }
        catch (IOException e) {
            Logger.error("\nFailed to create xpack folder! Please check if any files are in use.! ", e);
        }
        return file;
    }

    private Docker initDefaultDockerInfo() {
        if (this.docker == null) {
            this.docker = new Docker();
        }
        if (StringUtils.isBlank((String)this.docker.getRepo())) {
            this.docker.setRepo(this.groupId);
        }
        if (StringUtils.isBlank((String)this.docker.getName())) {
            this.docker.setName(this.artifactId);
        }
        if (StringUtils.isBlank((String)this.docker.getTag())) {
            this.docker.setTag(this.version);
        }
        if (StringUtils.isBlank((String)this.docker.getFromImage())) {
            this.docker.setFromImage(JDK8_IMAGE);
        }
        if (ArrayUtils.isEmpty((Object[])this.docker.getVolumes())) {
            this.docker.setVolumes(DEFAULT_VOLUMES);
        }
        return this.docker;
    }

    void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public Docker getDocker() {
        return this.docker;
    }
}

