/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.domain;

import cn.xphsc.xpack.domain.CopyResource;
import cn.xphsc.xpack.domain.Docker;
import cn.xphsc.xpack.domain.Linux;
import cn.xphsc.xpack.domain.PlatformEnum;
import cn.xphsc.xpack.domain.SkipErrorEnum;
import cn.xphsc.xpack.domain.Windows;
import java.io.File;
import java.util.Arrays;

public class PackInfo {
    private static final String JAR = ".jar";
    private File targetDir;
    private File homeDir;
    private String artifactId;
    private String version;
    private String name;
    private String description;
    private String vmOptions;
    private String programArgs;
    private String[] configFiles;
    private SkipErrorEnum skipError;
    private Windows windows;
    private Linux linux;
    private Docker docker;
    private String[] excludeFiles;
    private CopyResource[] copyResources;
    private boolean nameVersion;

    public static PackInfo newCommonPackInfo(PackInfo packInfo) {
        return new PackInfo().setTargetDir(packInfo.getTargetDir()).setHomeDir(packInfo.getHomeDir()).setArtifactId(packInfo.getArtifactId()).setVersion(packInfo.getVersion()).setName(packInfo.getName()).setNameVersion(packInfo.isNameVersion()).setDescription(packInfo.getDescription()).setVmOptions(packInfo.getVmOptions()).setProgramArgs(packInfo.getProgramArgs()).setConfigFiles(packInfo.getConfigFiles()).setSkipError(packInfo.getSkipError()).setWindows(packInfo.getWindows()).setLinux(packInfo.getLinux()).setDocker(packInfo.getDocker()).setExcludeFiles(packInfo.getExcludeFiles()).setCopyResources(packInfo.getCopyResources());
    }

    public String getFullJarName() {
        return this.name + JAR;
    }

    public String getPackName() {
        return this.homeDir.getAbsolutePath() + File.separator + (this.nameVersion ? this.name : this.artifactId);
    }

    public String getDockerPackName() {
        return this.homeDir.getAbsolutePath() + File.separator + this.docker.getImageTarName() + "-" + PlatformEnum.DOCKER.getCode();
    }

    public String toString() {
        return "PackInfo{targetDir=" + this.targetDir + ", homeDir=" + this.homeDir + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", vmOptions='" + this.vmOptions + '\'' + ", programArgs='" + this.programArgs + '\'' + ", configFiles=" + Arrays.toString(this.configFiles) + ", skipError=" + (Object)((Object)this.skipError) + ", windows=" + this.windows + ", linux=" + this.linux + ", docker=" + this.docker + ", excludeFiles=" + Arrays.toString(this.excludeFiles) + ", copyResources=" + Arrays.toString(this.copyResources) + ", nameVersion=" + this.nameVersion + '}';
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public PackInfo setTargetDir(File targetDir) {
        this.targetDir = targetDir;
        return this;
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public PackInfo setHomeDir(File homeDir) {
        this.homeDir = homeDir;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public PackInfo setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PackInfo setVersion(String version) {
        this.version = version;
        return this;
    }

    public PackInfo setNameVersion(boolean nameVersion) {
        this.nameVersion = nameVersion;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PackInfo setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public PackInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getVmOptions() {
        return this.vmOptions;
    }

    public PackInfo setVmOptions(String vmOptions) {
        this.vmOptions = vmOptions;
        return this;
    }

    public String getProgramArgs() {
        return this.programArgs;
    }

    public PackInfo setProgramArgs(String programArgs) {
        this.programArgs = programArgs;
        return this;
    }

    public String[] getConfigFiles() {
        return this.configFiles;
    }

    public PackInfo setConfigFiles(String[] configFiles) {
        this.configFiles = configFiles;
        return this;
    }

    public SkipErrorEnum getSkipError() {
        return this.skipError;
    }

    public PackInfo setSkipError(SkipErrorEnum skipError) {
        this.skipError = skipError;
        return this;
    }

    public Windows getWindows() {
        return this.windows;
    }

    public PackInfo setWindows(Windows windows) {
        this.windows = windows;
        return this;
    }

    public Linux getLinux() {
        return this.linux;
    }

    public PackInfo setLinux(Linux linux) {
        this.linux = linux;
        return this;
    }

    public Docker getDocker() {
        return this.docker;
    }

    public PackInfo setDocker(Docker docker) {
        this.docker = docker;
        return this;
    }

    public String[] getExcludeFiles() {
        return this.excludeFiles;
    }

    public PackInfo setExcludeFiles(String[] excludeFiles) {
        this.excludeFiles = excludeFiles;
        return this;
    }

    public CopyResource[] getCopyResources() {
        return this.copyResources;
    }

    public PackInfo setCopyResources(CopyResource[] copyResources) {
        this.copyResources = copyResources;
        return this;
    }

    public boolean isNameVersion() {
        return this.nameVersion;
    }

    public static String getJAR() {
        return JAR;
    }
}

