/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.domain;

import cn.xphsc.xpack.domain.BaseConfigure;
import cn.xphsc.xpack.domain.CopyResource;
import cn.xphsc.xpack.domain.PackInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.plexus.util.StringUtils;

public enum PlatformEnum {
    WINDOWS("windows"){

        @Override
        public PackInfo mergeNewPackInfo(PackInfo packInfo) {
            return 1.newBaseConfigPackInfo(packInfo, packInfo.getWindows());
        }
    }
    ,
    LINUX("linux"){

        @Override
        public PackInfo mergeNewPackInfo(PackInfo packInfo) {
            return 2.newBaseConfigPackInfo(packInfo, packInfo.getLinux());
        }
    }
    ,
    DOCKER("docker"){

        @Override
        public PackInfo mergeNewPackInfo(PackInfo packInfo) {
            return 3.newBaseConfigPackInfo(packInfo, packInfo.getDocker());
        }
    };

    private String code;

    private PlatformEnum(String code) {
        this.code = code;
    }

    public static PlatformEnum of(String platform) {
        for (PlatformEnum platformEnum : PlatformEnum.values()) {
            if (!platformEnum.code.equals(platform)) continue;
            return platformEnum;
        }
        return null;
    }

    public static List<PlatformEnum> getPlatformList() {
        ArrayList<PlatformEnum> platformList = new ArrayList<PlatformEnum>(PlatformEnum.values().length);
        Collections.addAll(platformList, PlatformEnum.values());
        return platformList;
    }

    public static PackInfo newBaseConfigPackInfo(PackInfo packInfo, BaseConfigure baseConfig) {
        PackInfo newPackInfo = PackInfo.newCommonPackInfo(packInfo);
        if (StringUtils.isNotBlank((String)baseConfig.getVmOptions())) {
            newPackInfo.setVmOptions(baseConfig.getVmOptions());
        }
        if (StringUtils.isNotBlank((String)baseConfig.getProgramArgs())) {
            newPackInfo.setProgramArgs(baseConfig.getProgramArgs());
        }
        if (ArrayUtils.isNotEmpty((Object[])baseConfig.getConfigFiles())) {
            newPackInfo.setConfigFiles((String[])ArrayUtils.addAll((Object[])packInfo.getConfigFiles(), (Object[])baseConfig.getConfigFiles()));
        }
        if (ArrayUtils.isNotEmpty((Object[])baseConfig.getCopyResources())) {
            newPackInfo.setCopyResources((CopyResource[])ArrayUtils.addAll((Object[])packInfo.getCopyResources(), (Object[])baseConfig.getCopyResources()));
        }
        if (ArrayUtils.isNotEmpty((Object[])baseConfig.getExcludeFiles())) {
            newPackInfo.setExcludeFiles((String[])ArrayUtils.addAll((Object[])packInfo.getExcludeFiles(), (Object[])baseConfig.getExcludeFiles()));
        }
        return newPackInfo;
    }

    public abstract PackInfo mergeNewPackInfo(PackInfo var1);

    public String getCode() {
        return this.code;
    }
}

