/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.handler;

import cn.xphsc.xpack.domain.CopyResource;
import cn.xphsc.xpack.domain.PackInfo;
import cn.xphsc.xpack.domain.PlatformEnum;
import cn.xphsc.xpack.handler.PackHandler;
import cn.xphsc.xpack.utils.Compress;
import cn.xphsc.xpack.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractPackHandler
implements PackHandler {
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    protected static final String BIN_DIR_NAME = "bin";
    private ResourceManager resourceManager;
    protected PackInfo packInfo;
    protected String platformPath;
    protected String binPath;

    protected void createPlatformCommonDir(PlatformEnum platformEnum) {
        this.initPlatformPath(platformEnum);
        try {
            this.resourceManager = (ResourceManager)new DefaultPlexusContainer().lookup(ResourceManager.ROLE);
            FileUtils.mkdir((String)this.platformPath);
            this.copyJarAndConfigFile();
        }
        catch (PlexusContainerException | ComponentLookupException e) {
            Logger.error("\u521b\u5efa\u3010" + this.platformPath + "\u3011\u76ee\u5f55\u6216\u8005\u590d\u5236\u76f8\u5173\u7684\u8d44\u6e90\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u5728\u4f7f\u7528!", e);
        }
    }

    protected void createBaseDirs() {
        this.binPath = this.platformPath + File.separator + BIN_DIR_NAME + File.separator;
        try {
            FileUtils.forceMkdir((File)new File(this.binPath));
            FileUtils.forceMkdir((File)new File(this.platformPath + File.separator + "config"));
            FileUtils.forceMkdir((File)new File(this.platformPath + File.separator + "docs"));
            FileUtils.forceMkdir((File)new File(this.platformPath + File.separator + "logs"));
            FileUtils.forceMkdir((File)new File(this.platformPath + File.separator + "lib"));
        }
        catch (IOException e) {
            Logger.error("\u521b\u5efa\u3010" + this.platformPath + "\u3011\u76ee\u5f55\u4e0b\u7684 bin\u3001config\u3001docs\u3001logs \u7b49\u76ee\u5f55\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u6b63\u5728\u4f7f\u7528!", e);
        }
    }

    private void copyJarAndConfigFile() {
        String jar = this.packInfo.getFullJarName();
        try {
            Object[] configFiles;
            FileUtils.copyFileToDirectory((String)(this.packInfo.getTargetDir().getAbsolutePath() + File.separator + jar), (String)this.platformPath);
            if (!this.packInfo.isNameVersion()) {
                File sourceFile = new File(this.platformPath + File.separator + jar);
                File targetFile = new File(this.platformPath + File.separator + this.packInfo.getArtifactId() + PackInfo.getJAR());
                sourceFile.renameTo(targetFile);
            }
            if (ArrayUtils.isNotEmpty((Object[])(configFiles = this.packInfo.getConfigFiles()))) {
                for (Object configFile : configFiles) {
                    this.copyCustomResources((String)configFile, "config");
                }
            }
        }
        catch (IOException e) {
            Logger.error("\u590d\u5236\u3010" + jar + "\u3011\u5230\u3010" + this.platformPath + "\u3011\u76ee\u5f55\u4e2d\u5931\u8d25\uff01\u5e94\u8be5\u8fd8\u6ca1\u6709\u6253\u5305\u6b64\u6587\u4ef6\uff0c" + "\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
    }

    private void initPlatformPath(PlatformEnum platformEnum) {
        this.platformPath = this.packInfo.getHomeDir().getAbsolutePath() + File.separator + platformEnum.getCode();
    }

    protected void copyFiles(String source, String destination) {
        try {
            FileUtils.copyFile((File)this.resourceManager.getResourceAsFile(source), (File)new File(this.platformPath, destination));
        }
        catch (IOException | FileResourceCreationException | ResourceNotFoundException e) {
            Logger.error("\u590d\u5236\u9ed8\u8ba4\u8d44\u6e90\u5230\u5e73\u53f0\u4e2d\u51fa\u9519\uff01", e);
        }
    }

    protected Map<String, Object> buildBaseTemplateContextMap() {
        HashMap<String, Object> context = new HashMap<String, Object>(8);
        context.put("name", this.packInfo.isNameVersion() ? this.packInfo.getName() : this.packInfo.getArtifactId());
        context.put("jarName", this.packInfo.isNameVersion() ? this.packInfo.getFullJarName() : this.packInfo.getArtifactId() + PackInfo.getJAR());
        context.put("vmOptions", StringUtils.isBlank((String)this.packInfo.getVmOptions()) ? "" : this.packInfo.getVmOptions());
        context.put("programArgs", StringUtils.isBlank((String)this.packInfo.getProgramArgs()) ? "" : this.packInfo.getProgramArgs());
        return context;
    }

    protected boolean isRootPath(String filePath) {
        return StringUtils.isBlank((String)filePath) || ".".equals(filePath) || "/".equals(filePath);
    }

    private void copyCustomResources() {
        Object[] copyResources = this.packInfo.getCopyResources();
        if (ArrayUtils.isEmpty((Object[])copyResources)) {
            return;
        }
        for (Object copyResource : copyResources) {
            String fromPath = ((CopyResource)copyResource).getOriginalResource();
            try {
                this.copyCustomResources(fromPath, ((CopyResource)copyResource).getTargetResource());
            }
            catch (IOException e) {
                Logger.error("\u590d\u5236\u914d\u7f6e\u7684\u81ea\u5b9a\u4e49\u8d44\u6e90\u3010" + fromPath + "\u3011\u5230\u5404\u5e73\u53f0\u7684\u5305\u4e2d\u51fa\u9519\uff01", e);
            }
        }
    }

    private void copyCustomResources(String originalResource, String targetResource) throws IOException {
        if (StringUtils.isBlank((String)originalResource)) {
            return;
        }
        if (originalResource.startsWith(HTTP) || originalResource.startsWith(HTTPS)) {
            String[] arr = originalResource.split("/");
            File dir = new File(this.platformPath + File.separator + targetResource);
            FileUtils.forceMkdir((File)dir);
            FileUtils.copyURLToFile((URL)new URL(originalResource), (File)new File(dir + File.separator + arr[arr.length - 1]));
        } else {
            File sourceFile = new File(originalResource);
            if (!sourceFile.exists()) {
                Logger.warn("\u3010\u8b66\u544a\u3011\u9700\u8981\u590d\u5236\u7684\u6e90\u8d44\u6e90\u6587\u4ef6\u3010" + originalResource + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                return;
            }
            File toDir = new File(this.isRootPath(targetResource) ? this.platformPath : this.platformPath + File.separator + targetResource);
            if (sourceFile.isDirectory()) {
                FileUtils.copyDirectoryStructure((File)sourceFile, (File)toDir);
            } else {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)toDir);
            }
        }
    }

    private void excludeFiles() {
        Object[] excludeFiles = this.packInfo.getExcludeFiles();
        if (ArrayUtils.isEmpty((Object[])excludeFiles)) {
            return;
        }
        for (Object path : excludeFiles) {
            String filePath = this.platformPath + File.separator + (String)path;
            File file = new File(filePath);
            if (!file.exists()) {
                Logger.warn("\u3010\u8b66\u544a\u3011\u4f60\u914d\u7f6e\u7684\u9700\u8981\u6392\u9664\u7684\u8d44\u6e90\u3010" + filePath + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                continue;
            }
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                Logger.error("\u3010\u9519\u8bef\u3011\u5220\u9664\u914d\u7f6e\u7684\u9700\u8981\u6392\u9664\u7684\u8d44\u6e90\u3010" + filePath + "\u3011\u51fa\u9519\uff01", e);
            }
        }
    }

    private void handleBeforeCompress() {
        this.copyCustomResources();
        this.excludeFiles();
    }

    protected void compress(PlatformEnum platformEnum) {
        this.handleBeforeCompress();
        String platform = platformEnum.getCode();
        Logger.debug("\u6b63\u5728\u5236\u4f5c " + platform + " \u4e0b\u7684\u90e8\u7f72\u538b\u7f29\u5305...");
        try {
            switch (platformEnum) {
                case WINDOWS: {
                    Compress.zip(this.platformPath, this.packInfo.getPackName() + ".zip");
                    break;
                }
                case LINUX: {
                    Compress.tarGz(this.platformPath, this.packInfo.getPackName() + ".tar.gz");
                    break;
                }
                case DOCKER: {
                    Compress.tarGz(this.platformPath, this.packInfo.getDockerPackName() + ".tar.gz");
                    break;
                }
            }
            FileUtils.forceDelete((String)this.platformPath);
            Logger.debug("\u5df2\u6e05\u9664 " + platform + " \u4e34\u65f6\u6587\u4ef6.");
        }
        catch (IOException e) {
            Logger.error("\u538b\u7f29\u5e76\u6e05\u9664 " + platform + " \u4e0b\u90e8\u7f72\u7684\u4e34\u65f6\u6587\u4ef6\u5931\u8d25.", e);
        }
        Logger.info("\u5236\u4f5c " + platform + " \u4e0b\u7684\u90e8\u7f72\u538b\u7f29\u5305\u5b8c\u6210.");
    }
}

