/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.handler;

import cn.xphsc.xpack.domain.PackInfo;
import cn.xphsc.xpack.domain.PlatformEnum;
import cn.xphsc.xpack.handler.PackHandler;
import cn.xphsc.xpack.handler.impl.DockerPackHandler;
import cn.xphsc.xpack.handler.impl.LinuxPackHandler;
import cn.xphsc.xpack.handler.impl.WindowsPackHandler;
import cn.xphsc.xpack.utils.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class XpackContext {
    private static final Map<PlatformEnum, PackHandler> PACK_HANDLER_MAP = new LinkedHashMap<PlatformEnum, PackHandler>(4);

    public void pack(String[] platforms, final PackInfo packInfo) {
        List<PlatformEnum> platformEnums = this.convertPlatformList(platforms);
        int count = platformEnums.size();
        final CountDownLatch countDownLatch = new CountDownLatch(count);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(count, count, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "xpack-thread");
            }
        });
        for (final PlatformEnum platformEnum : platformEnums) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    ((PackHandler)PACK_HANDLER_MAP.get((Object)platformEnum)).pack(platformEnum.mergeNewPackInfo(packInfo));
                    countDownLatch.countDown();
                }
            });
        }
        this.awaitAndShutdown(countDownLatch, executorService);
    }

    private List<PlatformEnum> convertPlatformList(String[] platforms) {
        if (ArrayUtils.isEmpty((Object[])platforms)) {
            return PlatformEnum.getPlatformList();
        }
        ArrayList<PlatformEnum> platformEnumList = new ArrayList<PlatformEnum>(platforms.length);
        for (String platform : platforms) {
            if (StringUtils.isBlank((CharSequence)platform)) {
                Logger.warn("\u4f60\u914d\u7f6e\u7684 xpack \u5e73\u53f0\u4e3a\u7a7a\uff01");
                continue;
            }
            PlatformEnum platformEnum = PlatformEnum.of(platform.trim().toLowerCase());
            if (platformEnum == null) {
                Logger.warn("\u4f60\u914d\u7f6e\u7684 xpack \u5e73\u53f0 " + platform + " \u4e0d\u5b58\u5728\uff01");
                continue;
            }
            platformEnumList.add(platformEnum);
        }
        return platformEnumList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAndShutdown(CountDownLatch countDownLatch, ExecutorService executorService) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Logger.error("\u5728\u591a\u7ebf\u7a0b\u4e0b\u7b49\u5f85 xpack \u6784\u5efa\u6253\u5305\u7ed3\u675f\u65f6\u51fa\u9519!", e);
            Thread.currentThread().interrupt();
        }
        finally {
            executorService.shutdown();
        }
    }

    static {
        PACK_HANDLER_MAP.put(PlatformEnum.WINDOWS, new WindowsPackHandler());
        PACK_HANDLER_MAP.put(PlatformEnum.LINUX, new LinuxPackHandler());
        PACK_HANDLER_MAP.put(PlatformEnum.DOCKER, new DockerPackHandler());
    }
}

