/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.handler.impl;

import cn.xphsc.xpack.domain.Docker;
import cn.xphsc.xpack.domain.DockerGoalEnum;
import cn.xphsc.xpack.domain.PackInfo;
import cn.xphsc.xpack.domain.PlatformEnum;
import cn.xphsc.xpack.domain.SkipErrorEnum;
import cn.xphsc.xpack.exception.ExceptionEnum;
import cn.xphsc.xpack.exception.XpackException;
import cn.xphsc.xpack.handler.AbstractPackHandler;
import cn.xphsc.xpack.utils.Logger;
import cn.xphsc.xpack.utils.Templates;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LoggingPushHandler;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.messages.ProgressMessage;
import com.spotify.docker.client.messages.RegistryAuth;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;

public class DockerPackHandler
extends AbstractPackHandler {
    private static final String DOCKER_FILE = "Dockerfile";
    private DockerClient dockerClient;
    private String imageName;

    @Override
    public void pack(PackInfo packInfo) {
        this.packInfo = packInfo;
        try {
            this.doPack();
        }
        catch (Exception e) {
            Logger.error("xpack \u6267\u884c Docker \u6784\u5efa\u5931\u8d25\uff01", e);
            throw e;
        }
        finally {
            this.clean();
        }
    }

    private void doPack() {
        if (SkipErrorEnum.TRUE == this.packInfo.getSkipError()) {
            try {
                this.doBuild();
                this.printFinished();
            }
            catch (Exception e) {
                Logger.error(e.getMessage());
            }
            return;
        }
        if (SkipErrorEnum.FALSE == this.packInfo.getSkipError()) {
            this.doBuild();
            this.printFinished();
            return;
        }
        try {
            this.checkDockerEnv();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return;
        }
        this.doBuildWithoutCheck();
        this.printFinished();
    }

    private void checkDockerEnv() {
        try {
            this.dockerClient = DefaultDockerClient.fromEnv().build();
            this.dockerClient.ping();
        }
        catch (Exception e) {
            throw new XpackException(ExceptionEnum.NO_DOCKER.getMsg(), e);
        }
    }

    private void initDockerfileAndJar() {
        super.createPlatformCommonDir(PlatformEnum.DOCKER);
        try {
            this.copyDockerfile();
        }
        catch (IOException e) {
            throw new XpackException(ExceptionEnum.NO_DOCKERFILE.getMsg(), e);
        }
    }

    private void buildImage() {
        try {
            this.imageName = this.packInfo.getDocker().getImageName();
            Logger.info("\u6b63\u5728\u6784\u5efa\u3010" + this.imageName + "\u3011\u955c\u50cf...");
            String imageId = this.dockerClient.build(Paths.get(this.platformPath, new String[0]), this.imageName, new DockerClient.BuildParam[0]);
            Logger.info("\u6784\u5efa\u3010" + this.imageName + "\u3011\u955c\u50cf\u5b8c\u6bd5\uff0c\u955c\u50cfID: " + imageId);
        }
        catch (Exception e) {
            throw new XpackException(ExceptionEnum.DOCKER_BUILD_EXCEPTION.getMsg(), e);
        }
    }

    private void saveImage() {
        try {
            String imageTar = this.packInfo.getDocker().getImageTarName() + ".tar";
            Logger.info("\u6b63\u5728\u5bfc\u51fa Docker \u955c\u50cf\u5305: " + imageTar + " ...");
            try (InputStream imageInput = this.dockerClient.save(new String[]{this.imageName});){
                org.codehaus.plexus.util.FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(imageInput), (File)new File(this.platformPath + File.separator + imageTar));
            }
            Logger.info("\u4ece Docker \u4e2d\u5bfc\u51fa\u955c\u50cf\u5305 " + imageTar + " \u6210\u529f.");
            this.handleFilesAndCompress();
        }
        catch (Exception e) {
            throw new XpackException(ExceptionEnum.DOCKER_SAVE_EXCEPTION.getMsg(), e);
        }
    }

    private void handleFilesAndCompress() throws IOException {
        org.codehaus.plexus.util.FileUtils.forceMkdir((File)new File(this.platformPath + File.separator + "docs"));
        super.copyFiles("docker/README.md", "README.md");
        super.compress(PlatformEnum.DOCKER);
    }

    private String tagImage(String registry) {
        try {
            String imageTagName = registry + "/" + this.imageName;
            this.dockerClient.tag(this.imageName, imageTagName, true);
            Logger.info("\u5df2\u5bf9\u672c\u6b21\u6784\u5efa\u7684\u955c\u50cf\u6253\u4e86\u6807\u7b7e\uff0c\u6807\u7b7e\u4e3a\uff1a\u3010" + imageTagName + "\u3011.");
            return imageTagName;
        }
        catch (Exception e) {
            throw new XpackException(ExceptionEnum.DOCKER_TAG_EXCEPTION.getMsg(), e);
        }
    }

    private void pushImage() {
        this.initDockercfgFile();
        Logger.info("\u6b63\u5728\u6821\u9a8c\u63a8\u9001\u955c\u50cf\u65f6\u9700\u8981\u7684 registry \u6388\u6743\u662f\u5426\u5408\u6cd5...");
        try {
            RegistryAuth auth = RegistryAuth.builder().build();
            int statusCode = this.dockerClient.auth(auth);
            int code = 200;
            if (statusCode != code) {
                Logger.warn("\u6821\u9a8c registry \u6388\u6743\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u63a8\u9001\u955c\u50cf\u5230\u8fdc\u7a0b\u955c\u50cf\u4ed3\u5e93\u4e2d.");
                return;
            }
            String registry = this.packInfo.getDocker().getRegistry();
            String imageTagName = StringUtils.isBlank((String)registry) ? this.imageName : this.tagImage(registry);
            Logger.info("\u6b63\u5728\u63a8\u9001\u6807\u7b7e\u4e3a\u3010" + imageTagName + "\u3011\u7684\u955c\u50cf\u5230\u8fdc\u7a0b\u4ed3\u5e93\u4e2d...");
            this.dockerClient.push(imageTagName, (ProgressHandler)new LoggingPushHandler(imageTagName), auth);
            Logger.info("\u63a8\u9001\u6807\u7b7e\u4e3a\u3010" + imageTagName + "\u3011\u7684\u955c\u50cf\u5230\u8fdc\u7a0b\u4ed3\u5e93\u4e2d\u6210\u529f.");
        }
        catch (Exception e) {
            throw new XpackException(ExceptionEnum.DOCKER_PUSH_EXCEPTION.getMsg(), e);
        }
    }

    private void doBuild() {
        this.checkDockerEnv();
        this.doBuildWithoutCheck();
    }

    private void doBuildWithoutCheck() {
        String[] goalTypes;
        this.initDockerfileAndJar();
        this.buildImage();
        Docker dockerInfo = this.packInfo.getDocker();
        if (dockerInfo == null || (goalTypes = dockerInfo.getExtraGoals()) == null || goalTypes.length == 0) {
            Logger.debug("\u5728 xpack \u4e2d\u672a\u914d\u7f6e  docker \u989d\u5916\u6784\u5efa\u76ee\u6807\u7c7b\u578b'goalTypes'\u7684\u503c\uff0c\u53ea\u4f1a\u6784\u5efa\u955c\u50cf.");
            return;
        }
        HashSet<DockerGoalEnum> goalEnumSet = new HashSet<DockerGoalEnum>(4);
        for (String goal : goalTypes) {
            DockerGoalEnum goalEnum = DockerGoalEnum.of(goal);
            if (goalEnum == null) continue;
            goalEnumSet.add(goalEnum);
        }
        if (goalEnumSet.isEmpty()) {
            Logger.warn("\u5728 xpack \u4e2d\u914d\u7f6e docker \u7684\u989d\u5916\u6784\u5efa\u76ee\u6807\u7c7b\u578b'goalTypes'\u7684\u503c\u4e0d\u662f save \u6216\u8005 push\uff0c\u5c06\u5ffd\u7565\u540e\u7eed\u7684\u6784\u5efa.");
            return;
        }
        if (goalEnumSet.size() == 1) {
            if (goalEnumSet.contains((Object)DockerGoalEnum.SAVE)) {
                this.saveImage();
            } else if (goalEnumSet.contains((Object)DockerGoalEnum.PUSH)) {
                this.pushImage();
            }
        } else {
            this.saveImage();
            this.pushImage();
        }
    }

    private void copyDockerfile() throws IOException {
        Docker docker = this.packInfo.getDocker();
        if (StringUtils.isBlank((String)docker.getDockerfile())) {
            Logger.info("\u5c06\u4f7f\u7528 xpack \u9ed8\u8ba4\u63d0\u4f9b\u7684 Dockerfile \u6587\u4ef6\u6765\u6784\u5efa\u955c\u50cf.");
            Map<String, Object> context = super.buildBaseTemplateContextMap();
            context.put("jdkImage", docker.getFromImage());
            context.put("valume", this.buildVolumes(docker.getVolumes()));
            context.put("customCommands", this.buildCustomCommands(docker.getCustomCommands()));
            context.put("expose", this.buildExpose(docker.getExpose()));
            Templates.renderFile("docker/Dockerfile", context, this.platformPath + File.separator + DOCKER_FILE);
            return;
        }
        Logger.info("\u5f00\u59cb\u6e32\u67d3\u4f60\u81ea\u5b9a\u4e49\u7684 Dockerfile \u6587\u4ef6\u4e2d\u7684\u5185\u5bb9.");
        String dockerFilePath = docker.getDockerfile();
        File dockerFile = new File(super.isRootPath(dockerFilePath) ? DOCKER_FILE : dockerFilePath);
        if (!dockerFile.exists() || dockerFile.isDirectory()) {
            throw new XpackException(ExceptionEnum.NO_DOCKERFILE.getMsg());
        }
        org.codehaus.plexus.util.FileUtils.copyFileToDirectory((File)dockerFile, (File)new File(this.platformPath));
    }

    private String buildVolumes(String[] volumes) {
        return ArrayUtils.isNotEmpty((Object[])volumes) ? "VOLUME [\"" + StringUtils.join((Object[])volumes, (String)"\", \"") + "\"]\n" : "";
    }

    private String buildExpose(String expose) {
        return StringUtils.isEmpty((String)expose) ? "" : "\nEXPOSE " + expose.trim() + "\n";
    }

    private String buildCustomCommands(String[] customCommands) {
        StringBuilder sb = new StringBuilder();
        if (ArrayUtils.isNotEmpty((Object[])customCommands)) {
            for (String command : customCommands) {
                sb.append(command).append("\n");
            }
        }
        return sb.toString();
    }

    private void initDockercfgFile() {
        File dockercfgFile = new File(System.getProperty("user.home") + File.separator + ".dockercfg");
        if (!dockercfgFile.exists()) {
            try {
                FileUtils.touch((File)dockercfgFile);
            }
            catch (IOException e) {
                Logger.error("\u521d\u59cb\u5316 ~/.dockercfg \u6587\u4ef6\u5931\u8d25\uff01", e);
            }
        }
    }

    private void printProgress(ProgressMessage msg) {
        String progress = msg.progress();
        if (StringUtils.isNotBlank((String)progress)) {
            Logger.info(progress);
        }
    }

    private void printFinished() {
        Logger.debug("xpack \u5173\u4e8e Docker \u7684\u76f8\u5173\u6784\u5efa\u64cd\u4f5c\u6267\u884c\u5b8c\u6bd5.");
    }

    private void clean() {
        if (this.dockerClient != null) {
            this.dockerClient.close();
        }
        try {
            org.codehaus.plexus.util.FileUtils.forceDelete((String)this.platformPath);
        }
        catch (Exception e) {
            Logger.debug("\u5220\u9664\u6e05\u9664 docker \u4e0b\u7684\u4e34\u65f6\u6587\u4ef6\u5931\u8d25.");
        }
    }
}

