/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.handler.impl;

import cn.xphsc.xpack.domain.PackInfo;
import cn.xphsc.xpack.domain.PlatformEnum;
import cn.xphsc.xpack.handler.AbstractPackHandler;
import cn.xphsc.xpack.utils.Logger;
import cn.xphsc.xpack.utils.Templates;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class WindowsPackHandler
extends AbstractPackHandler {
    private static final String[] BAT_NAME_ARR = new String[]{"install", "uninstall", "start", "stop", "restart"};

    @Override
    public void pack(PackInfo packInfo) {
        this.packInfo = packInfo;
        super.createPlatformCommonDir(PlatformEnum.WINDOWS);
        super.createBaseDirs();
        super.copyFiles("windows/README.md", "README.md");
        String projectName = "bin" + File.separator + (packInfo.isNameVersion() ? packInfo.getName() : packInfo.getArtifactId());
        this.renderWinswXml(this.platformPath + File.separator + projectName + ".xml", packInfo);
        super.copyFiles("windows/bin/winsw.exe", projectName + ".exe");
        super.copyFiles("windows/bin/winsw.exe.config", projectName + ".exe.config");
        this.createAllBatFiles(packInfo.isNameVersion() ? packInfo.getName() : packInfo.getArtifactId());
        super.compress(PlatformEnum.WINDOWS);
    }

    private void renderWinswXml(String destXml, PackInfo packInfo) {
        HashMap<String, Object> context = new HashMap<String, Object>(8);
        context.put("projectId", packInfo.getArtifactId());
        context.put("name", packInfo.isNameVersion() ? packInfo.getName() : packInfo.getArtifactId());
        context.put("description", packInfo.getDescription());
        String vmOptions = StringUtils.isBlank((CharSequence)packInfo.getVmOptions()) ? "" : packInfo.getVmOptions() + " ";
        String args = StringUtils.isBlank((CharSequence)packInfo.getProgramArgs()) ? "" : " " + packInfo.getProgramArgs();
        context.put("arguments", vmOptions + "-jar ..\\" + (packInfo.isNameVersion() ? packInfo.getFullJarName() : packInfo.getArtifactId() + PackInfo.getJAR()) + args);
        try {
            Templates.renderFile("windows/bin/winsw.xml", context, destXml);
        }
        catch (IOException e) {
            Logger.error("\u6e32\u67d3 winsw.xml \u6a21\u677f\u5185\u5bb9\u5e76\u5199\u5165 bin \u76ee\u5f55\u4e2d\u51fa\u9519\uff01", e);
        }
    }

    private void createAllBatFiles(String name) {
        try {
            for (String batName : BAT_NAME_ARR) {
                HashMap<String, Object> context = new HashMap<String, Object>(4);
                context.put("name", name);
                context.put("batName", batName);
                Templates.renderFile("windows/bin/template.bat", context, this.binPath + batName + ".bat");
            }
        }
        catch (IOException e) {
            Logger.error("\u6e32\u67d3 template.bat \u6a21\u677f\u5185\u5bb9\u5e76\u5199\u5165\u5230 bin \u76ee\u5f55\u4e2d\u51fa\u9519\uff01", e);
        }
    }
}

