/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class Compress {
    private Compress() {
    }

    public static void zip(String dir, String zipPath) throws IOException {
        Compress.compressFilesZip(Compress.getDirFiles(dir), zipPath, dir);
    }

    private static List<String> getDirFiles(String dir) {
        File[] files = new File(dir).listFiles();
        if (files == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> filePaths = new ArrayList<String>(files.length);
        for (File file : files) {
            if (file.isDirectory()) {
                filePaths.add(file.getAbsolutePath());
                filePaths.addAll(Compress.getDirFiles(file.getAbsolutePath()));
                continue;
            }
            filePaths.add(file.getAbsolutePath());
        }
        return filePaths;
    }

    private static String getFilePathName(String dir, String path) {
        String p = path.replace(dir + File.separator, "");
        p = p.replace("\\", "/");
        return p;
    }

    private static void compressFilesZip(List<String> filePaths, String zipFilePath, String dir) throws IOException {
        if (filePaths == null || filePaths.isEmpty()) {
            return;
        }
        List<File> files = Compress.getAllFiles(filePaths);
        try (ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(new File(zipFilePath));){
            zaos.setUseZip64(Zip64Mode.AsNeeded);
            for (File file : files) {
                zaos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(file, Compress.getFilePathName(dir, file.getAbsolutePath())));
                if (file.isDirectory()) continue;
                Compress.compressFile(zaos, file);
            }
            zaos.finish();
        }
    }

    private static List<File> getAllFiles(List<String> filePaths) {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : filePaths) {
            File file = new File(filePath);
            if (file.isDirectory()) {
                dirs.add(file);
                continue;
            }
            files.add(file);
        }
        dirs.addAll(files);
        return dirs;
    }

    private static void compressFile(ZipArchiveOutputStream zaos, File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(is);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = ((InputStream)bis).read(buffer)) != -1) {
                zaos.write(buffer, 0, len);
            }
            zaos.closeArchiveEntry();
        }
    }

    public static void tarGz(String dirPath, String tarGzPath) throws IOException {
        File tarGzFile = new File(tarGzPath);
        try (FileOutputStream fos = new FileOutputStream(tarGzFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)bos);
             TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)gcos);){
            String tarGzName = tarGzFile.getName().split(".tar.gz")[0] + File.separator;
            File[] children = new File(dirPath).listFiles();
            if (children != null && children.length > 0) {
                for (File child : children) {
                    Compress.addFileToTarGz(taos, child.getAbsolutePath(), tarGzName);
                }
            }
            taos.finish();
        }
    }

    private static void addFileToTarGz(TarArchiveOutputStream taos, String dirPath, String base) throws IOException {
        File f = new File(dirPath);
        String entryName = base + f.getName();
        taos.putArchiveEntry((ArchiveEntry)new TarArchiveEntry(f, entryName));
        if (f.isFile()) {
            try (FileInputStream in = new FileInputStream(f);){
                IOUtils.copy((InputStream)in, (OutputStream)taos);
            }
            taos.closeArchiveEntry();
        } else {
            taos.closeArchiveEntry();
            File[] children = f.listFiles();
            if (children != null && children.length > 0) {
                for (File child : children) {
                    Compress.addFileToTarGz(taos, child.getAbsolutePath(), entryName + "/");
                }
            }
        }
    }
}

