/*
 * Decompiled with CFR 0.152.
 */
package cn.xphsc.xpack.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public final class Times {
    static final String EMPTY = "";

    private Times() {
    }

    static String join(Object ... objects) {
        if (objects != null && objects.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (Object o : objects) {
                sb.append(o == null ? EMPTY : o.toString());
            }
            return sb.toString();
        }
        return EMPTY;
    }

    public static String convertTime(Number n) {
        double d = n.doubleValue();
        if (d < 100000.0) {
            return Long.toString(n.longValue()).concat(" ns");
        }
        if (d >= 10000.0 && d < 1.0E9) {
            return Times.getRoundString(d / 1000000.0, "ms");
        }
        if (d >= 1.0E9 && d < 6.0E10) {
            return Times.getRoundString(d / 1.0E9, "s");
        }
        if (d >= 6.0E10 && d < 3.6E12) {
            return Times.getRoundString(d / 6.0E10, "min");
        }
        if (d >= 3.6E12 && d < 8.64E13) {
            return Times.getRoundString(d / 3.6E12, "h");
        }
        return Times.getRoundString(d / 8.64E13, "d");
    }

    private static String getRoundString(double d, String unit) {
        return Times.join(BigDecimal.valueOf(d).setScale(2, RoundingMode.HALF_UP).doubleValue(), " ", unit);
    }
}

