/*
 * Decompiled with CFR 0.152.
 */
package cn.xsaf1207.interceptor;

import cn.xsaf1207.model.Page;
import cn.xsaf1207.utils.page.MSUtil;
import cn.xsaf1207.utils.page.PageUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
@Component
public class PageInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        Page page = PageUtil.getLocalPage();
        if (Objects.nonNull(page) && page.getIsPage().booleanValue()) {
            String countSql = PageUtil.getCountSql(boundSql.getSql(), "0");
            BoundSql countBoundSql = new BoundSql(ms.getConfiguration(), countSql, new ArrayList(), null);
            CacheKey countKey = executor.createCacheKey(ms, null, RowBounds.DEFAULT, countBoundSql);
            MappedStatement countMs = MSUtil.newCountMappedStatement(ms, "COUNT");
            List countResultList = executor.query(countMs, null, RowBounds.DEFAULT, null, countKey, countBoundSql);
            int total = ((Number)countResultList.get(0)).intValue();
            page.setTotal(total);
            if (total == 0) {
                return new ArrayList(0);
            }
            Map<String, Object> paramMap = PageUtil.processParamMap(ms, parameter, boundSql);
            parameter = PageUtil.processPageParameter(ms, paramMap, boundSql, cacheKey);
            String pageSql = PageUtil.getPageSql(boundSql.getSql());
            BoundSql pageBoundSql = new BoundSql(ms.getConfiguration(), pageSql, boundSql.getParameterMappings(), parameter);
            Field addParameters = BoundSql.class.getDeclaredField("additionalParameters");
            addParameters.setAccessible(true);
            Map additionalParameters = (Map)addParameters.get(boundSql);
            for (String key : additionalParameters.keySet()) {
                pageBoundSql.setAdditionalParameter(key, additionalParameters.get(key));
            }
            return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, pageBoundSql);
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

