/*
 * Decompiled with CFR 0.152.
 */
package cn.xsaf1207.utils.page;

import cn.xsaf1207.model.Page;
import cn.xsaf1207.utils.TypeConvertUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

public class PageUtil {
    protected static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();

    public static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    public static Page getLocalPage() {
        return LOCAL_PAGE.get();
    }

    public static int getCount() {
        return TypeConvertUtil.toInt(LOCAL_PAGE.get().getTotal(), 0);
    }

    public static void clearPage() {
        LOCAL_PAGE.remove();
    }

    public static String getCountSql(String sql, String name) {
        StringBuilder stringBuilder = new StringBuilder(sql.length() + 40);
        stringBuilder.append("select count(");
        stringBuilder.append(name);
        stringBuilder.append(") from ( \n");
        stringBuilder.append(sql);
        stringBuilder.append("\n ) tmp_count");
        return stringBuilder.toString();
    }

    public static String getPageSql(String sql) {
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 14);
        sqlBuilder.append(sql);
        if (LOCAL_PAGE.get().getPageNum() == 1) {
            sqlBuilder.append("\n LIMIT ? ");
        } else {
            sqlBuilder.append("\n LIMIT ?, ? ");
        }
        return sqlBuilder.toString();
    }

    public static Map<String, Object> processParamMap(MappedStatement ms, Object parameter, BoundSql boundSql) throws NoSuchFieldException, IllegalAccessException {
        HashMap<String, Object> paramMap = null;
        if (parameter == null) {
            paramMap = new HashMap<String, Object>();
        } else if (parameter instanceof Map) {
            paramMap = new HashMap();
            paramMap.putAll((Map)parameter);
        } else {
            Field methodArgumentNames;
            String[] providerMethodArgumentNames;
            paramMap = new HashMap();
            if (ms.getSqlSource() instanceof ProviderSqlSource && (providerMethodArgumentNames = (String[])(methodArgumentNames = ProviderSqlSource.class.getDeclaredField("providerMethodArgumentNames")).get(ms.getSqlSource())) != null && providerMethodArgumentNames.length == 1) {
                paramMap.put(providerMethodArgumentNames[0], parameter);
                paramMap.put("param1", parameter);
            }
            boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameter.getClass());
            MetaObject metaObject = MetaObject.forObject((Object)parameter, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
            if (!hasTypeHandler) {
                for (String name : metaObject.getGetterNames()) {
                    paramMap.put(name, metaObject.getValue(name));
                }
            }
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (name.equals("page_first") || name.equals("page_second") || paramMap.get(name) != null || !hasTypeHandler && !parameterMapping.getJavaType().equals(parameter.getClass())) continue;
                    paramMap.put(name, parameter);
                    break;
                }
            }
        }
        return paramMap;
    }

    public static Object processPageParameter(MappedStatement ms, Map<String, Object> paramMap, BoundSql boundSql, CacheKey pageKey) {
        Page page = LOCAL_PAGE.get();
        int start = page.getPageNum() == 1 ? 0 : (page.getPageNum() - 1) * page.getPageSize();
        paramMap.put("page_first", start);
        paramMap.put("page_second", page.getPageSize());
        pageKey.update((Object)start);
        pageKey.update((Object)page.getPageSize());
        if (boundSql.getParameterMappings() != null) {
            ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
            if (start == 0) {
                newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "page_second", Integer.TYPE).build());
            } else {
                newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "page_first", Integer.TYPE).build());
                newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), "page_second", Integer.TYPE).build());
            }
            MetaObject metaObject = MetaObject.forObject((Object)boundSql, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
            metaObject.setValue("parameterMappings", newParameterMappings);
        }
        return paramMap;
    }
}

