/*
 * Decompiled with CFR 0.152.
 */
package cn.xsaf1207.utils;

import cn.xsaf1207.utils.TypeConvertUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    public static String getParameter(String name) {
        return ServletUtil.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return TypeConvertUtil.toStr(ServletUtil.getRequest().getParameter(name), defaultValue);
    }

    public static Integer getParameterToInt(String name) {
        return TypeConvertUtil.toInt(ServletUtil.getRequest().getParameter(name));
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        return TypeConvertUtil.toInt(ServletUtil.getRequest().getParameter(name), defaultValue);
    }

    public static Boolean getParameterToBool(String name) {
        return TypeConvertUtil.toBool(ServletUtil.getRequest().getParameter(name));
    }

    public static Boolean getParameterToBool(String name, Boolean defaultValue) {
        return TypeConvertUtil.toBool(ServletUtil.getRequest().getParameter(name), defaultValue);
    }

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtil.getParams(request).entrySet()) {
            params.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (String)","));
        }
        return params;
    }

    public static HttpServletRequest getRequest() {
        return ServletUtil.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtil.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtil.getRequest().getSession();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static void renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtils.trim((String)s))) continue;
                return true;
            }
        }
        return false;
    }
}

