/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.common.util;

import cn.xuqiudong.common.base.craw.CrawlConnect;
import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.common.util.JsonUtil;
import cn.xuqiudong.sso.common.enums.GrantTypeEnum;
import cn.xuqiudong.sso.common.model.RpcAccessToken;
import cn.xuqiudong.sso.common.util.SsoHttpUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;

public class SsoOauth2Util {
    public static BaseResponse<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
        CrawlConnect connect = SsoHttpUtil.connect(serverUrl + "/oauth2/refresh_token");
        connect.data("appId", appId).data("refreshToken", refreshToken);
        return SsoOauth2Util.getRpcAccessTokenBaseResponse(connect);
    }

    public static BaseResponse<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String code) {
        CrawlConnect connect = SsoHttpUtil.connect(serverUrl + "/oauth2/access_token");
        connect.data("grantType", GrantTypeEnum.AUTHORIZATION_CODE.name()).data("appId", appId).data("appSecret", appSecret).data("code", code);
        return SsoOauth2Util.getRpcAccessTokenBaseResponse(connect);
    }

    public static BaseResponse<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password) {
        CrawlConnect connect = SsoHttpUtil.connect(serverUrl + "/oauth2/access_token");
        connect.data("grantType", GrantTypeEnum.PASSWORD.name()).data("appId", appId).data("appSecret", appSecret).data("username", username).data("password", password);
        return SsoOauth2Util.getRpcAccessTokenBaseResponse(connect);
    }

    private static BaseResponse<RpcAccessToken> getRpcAccessTokenBaseResponse(CrawlConnect connect) {
        try {
            String text = connect.postBodyText();
            return (BaseResponse)JsonUtil.jsonToObject((String)text, (TypeReference)new TypeReference<BaseResponse<RpcAccessToken>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
            return BaseResponse.error((String)("\u53d1\u751f\u4e86\u4e00\u4e9b\u9519\u8bef\uff1a" + e.getMessage()));
        }
    }
}

