/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.common.util;

import cn.xuqiudong.sso.common.model.RpcAccessToken;
import cn.xuqiudong.sso.common.model.SessionAccessToken;
import javax.servlet.http.HttpServletRequest;

public class SsoSessionUtil {
    public static SessionAccessToken getAccessToken(HttpServletRequest request) {
        return (SessionAccessToken)request.getSession().getAttribute("_sessionAccessToken");
    }

    public static void removeAccessToken(HttpServletRequest request) {
        request.getSession().removeAttribute("_sessionAccessToken");
    }

    public static void setAccessToken(HttpServletRequest request, RpcAccessToken rpcAccessToken) {
        SessionAccessToken sessionAccessToken = null;
        if (rpcAccessToken != null) {
            sessionAccessToken = SsoSessionUtil.createSessionAccessToken(rpcAccessToken);
        }
        request.getSession().setAttribute("_sessionAccessToken", (Object)sessionAccessToken);
    }

    private static SessionAccessToken createSessionAccessToken(RpcAccessToken accessToken) {
        long expirationTime = System.currentTimeMillis() + (long)accessToken.getExpiresIn() * 1000L;
        return new SessionAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn(), accessToken.getRefreshToken(), accessToken.getUser(), expirationTime);
    }
}

