/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.sso.common.util;

import cn.xuqiudong.common.util.CookieUtil;
import cn.xuqiudong.common.util.JsonUtil;
import cn.xuqiudong.sso.common.model.SsoUser;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SsoCookieUtil {
    public static String rememberMe(SsoUser user, HttpServletResponse response) {
        if (user == null || response == null) {
            return null;
        }
        String tokenJson = JsonUtil.toJson((Object)user);
        String tokenHex = new BigInteger(tokenJson.getBytes()).toString(16);
        CookieUtil.set((HttpServletResponse)response, (String)"CAS_SSO_COOKIE_PRINCIPAL", (String)tokenHex, (boolean)true);
        return tokenHex;
    }

    public static void removeRememberMe(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.remove((HttpServletRequest)request, (HttpServletResponse)response, (String)"CAS_SSO_COOKIE_PRINCIPAL");
    }

    public static SsoUser rememberedUser(HttpServletRequest request) {
        SsoUser user = null;
        String cookieToken = CookieUtil.getValue((HttpServletRequest)request, (String)"CAS_SSO_COOKIE_PRINCIPAL");
        if (cookieToken != null) {
            String tokenJson = new String(new BigInteger(cookieToken, 16).toByteArray());
            user = (SsoUser)JsonUtil.jsonToObject((String)tokenJson, SsoUser.class);
        }
        return user;
    }
}

