/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.aspect;

import cn.xuqiudong.common.base.aspect.annotation.RepeatCommitVersion;
import cn.xuqiudong.common.base.enums.CommonMsgEnum;
import cn.xuqiudong.common.base.exception.CommonException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RepeatCommitVersionAspect {
    @Resource
    private HttpServletRequest request;
    public Logger logger = LoggerFactory.getLogger(RepeatCommitVersionAspect.class);
    @Resource
    private JdbcTemplate jdbcTemplate;

    public RepeatCommitVersionAspect() {
    }

    public RepeatCommitVersionAspect(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Pointcut(value="@annotation(cn.xuqiudong.common.base.aspect.annotation.RepeatCommitVersion)")
    public void version() {
    }

    @Before(value="version()")
    public void before(JoinPoint joinPoint) {
        RepeatCommitVersion version = this.getVersion(joinPoint);
        String versionAttributeValue = this.request.getParameter(version.versionAttribute());
        String id = this.request.getParameter(version.idAttribute());
        if (id == null || id.trim().length() == 0) {
            this.logger.debug("\u63d0\u4ea4\u7684\u8868\u5355\u65e0id\u7684\u503c\uff0c\u65e0\u9700\u8fdb\u884cversion \u91cd\u590d\u63d0\u4ea4\u68c0\u9a8c");
            return;
        }
        try {
            int formVersion = Integer.parseInt(versionAttributeValue);
            int oldVersion = this.findOldVersion(version, id);
            if (oldVersion > formVersion) {
                this.logger.info("\u9875\u9762\u7684version {}\u5927\u4e8e\u6570\u636e\u5e93\u7684version {}\uff0c\u4e0d\u53ef\u63d0\u4ea4", (Object)formVersion, (Object)oldVersion);
                throw new CommonException(CommonMsgEnum.REPEAT_COMMIT);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CommonException(CommonMsgEnum.REPEAT_COMMIT);
        }
    }

    private int findOldVersion(RepeatCommitVersion version, Object id) {
        String sql = "select " + version.column() + " from " + version.table() + " where id = " + id;
        try {
            Integer oldValue = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
            return oldValue == null ? 0 : oldValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CommonException(CommonMsgEnum.REPEAT_COMMIT);
        }
    }

    private RepeatCommitVersion getVersion(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        RepeatCommitVersion annotation = signature.getMethod().getAnnotation(RepeatCommitVersion.class);
        return annotation;
    }
}

