/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.aspect;

import cn.xuqiudong.common.base.aspect.annotation.LogPrint;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Enumeration;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RequestLogPrintAspect {
    @Resource
    private HttpServletRequest request;
    public Logger logger = LoggerFactory.getLogger(RequestLogPrintAspect.class);
    private static final String CURRENT_REQUEST_TIME = "current_request_time";
    private static final String CURRENT_REQUEST_FLAG = "request_log_print_aspect_flag";
    private static final String LOG_NAME = "\u3010request log\u3011";
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Pointcut(value="@annotation(cn.xuqiudong.common.base.aspect.annotation.LogPrint)")
    public void log() {
    }

    @Before(value="log()")
    public void before(JoinPoint joinPoint) {
        long inTime = System.currentTimeMillis();
        this.request.setAttribute(CURRENT_REQUEST_TIME, (Object)inTime);
        String controller = joinPoint.getTarget().getClass().getSimpleName();
        String method = joinPoint.getSignature().getName();
        StringBuffer flag = new StringBuffer(String.valueOf(inTime));
        flag.append("-").append(controller).append(".").append(method);
        this.request.setAttribute(CURRENT_REQUEST_FLAG, (Object)flag.toString());
        LogPrint logPrint = this.getLogPrint(joinPoint);
        if (!logPrint.in()) {
            return;
        }
        StringBuilder paramsStringBuilder = new StringBuilder();
        Enumeration e = this.request.getParameterNames();
        if (e.hasMoreElements()) {
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                CharSequence[] values = this.request.getParameterValues(name);
                if (values.length == 1) {
                    paramsStringBuilder.append(name).append("=").append(values[0]);
                } else {
                    paramsStringBuilder.append(name).append("[]={").append(String.join((CharSequence)",", values)).append("}");
                }
                paramsStringBuilder.append(",");
            }
        }
        if (paramsStringBuilder.length() > 0) {
            paramsStringBuilder.deleteCharAt(paramsStringBuilder.length() - 1);
        }
        this.printLog(flag.toString(), "\u5165\u53c2", paramsStringBuilder.toString());
    }

    @AfterReturning(pointcut="log()", returning="returnValue")
    public void afterReturning(JoinPoint joinPoint, Object returnValue) {
        LogPrint logPrint = this.getLogPrint(joinPoint);
        String flag = (String)this.request.getAttribute(CURRENT_REQUEST_FLAG);
        if (logPrint.time()) {
            long in = (Long)this.request.getAttribute(CURRENT_REQUEST_TIME);
            long time = System.currentTimeMillis() - in;
            this.printLog(flag, "\u8017\u65f6", time + "ms");
        }
        if (logPrint.out()) {
            String out = null;
            try {
                out = objectMapper.writeValueAsString(returnValue);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                out = returnValue + "";
            }
            this.printLog(flag, "\u51fa\u53c2", out);
        }
    }

    private void printLog(String flag, String type, String content) {
        String info = LOG_NAME + flag + " " + type + ":{" + content + "}";
        this.logger.info(info);
    }

    private LogPrint getLogPrint(@NotNull JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        LogPrint annotation = signature.getMethod().getAnnotation(LogPrint.class);
        return annotation;
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

