/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.cache;

import java.lang.reflect.Method;
import java.util.Date;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CommonKeyGenerator
implements KeyGenerator {
    public static final String GENERATOR_NAME = "commonKeyGenerator";
    private static final String DELIMITER = ":";
    private static final String PARAMS_DELIMITER = "-";
    private static final String EMPTY = "0";
    private static final String DEFAULT_PREFIX = "cache";
    private String prefix;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Object generate(Object target, Method method, Object ... params) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCacheName(method)).append(DELIMITER);
        if (params == null || params.length == 0) {
            sb.append(EMPTY);
        } else {
            for (Object param : params) {
                if (param == null) continue;
                if (!CommonKeyGenerator.isSimpleType(param.getClass())) {
                    param = param.hashCode();
                }
                sb.append(param).append(PARAMS_DELIMITER);
            }
        }
        if (sb.toString().endsWith(PARAMS_DELIMITER)) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return ClassUtils.isPrimitiveOrWrapper(clazz) || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    private String getCacheName(Method method) {
        String cacheName = "";
        if (method.isAnnotationPresent(Cacheable.class)) {
            Cacheable cacheable = method.getAnnotation(Cacheable.class);
            cacheName = CommonKeyGenerator.getFirstCacheName(cacheable.value());
        } else if (method.isAnnotationPresent(CacheEvict.class)) {
            CacheEvict cacheable = method.getAnnotation(CacheEvict.class);
            cacheName = CommonKeyGenerator.getFirstCacheName(cacheable.value());
        } else if (method.isAnnotationPresent(CachePut.class)) {
            CachePut cacheable = method.getAnnotation(CachePut.class);
            cacheName = CommonKeyGenerator.getFirstCacheName(cacheable.value());
        }
        return this.addPrefix(cacheName);
    }

    private String addPrefix(String cacheName) {
        String prefix = StringUtils.isEmpty((Object)this.getPrefix()) ? DEFAULT_PREFIX : this.getPrefix();
        return prefix + DELIMITER + cacheName;
    }

    private static String getFirstCacheName(String[] names) {
        if (names != null && names.length > 0) {
            return names[0];
        }
        return "";
    }
}

