/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.cache;

import cn.xuqiudong.common.base.tool.ApplicationContextHolder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCache
implements Cache {
    private static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String id;
    private static String REDIS_TEMPLATE_NAME = "redisTemplateCustomize";
    private RedisTemplate<String, Object> redisTemplate;
    private static final long EXPIRE_TIME_IN_MINUTES = 120L;

    public static void setRedisTemplateName(String name) {
        REDIS_TEMPLATE_NAME = name;
    }

    public RedisCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void putObject(Object key, Object value) {
        logger.debug("putObject id=[{}],key=[{}]", (Object)this.id, key);
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        HashOperations opsForHash = redisTemplate.opsForHash();
        opsForHash.put((Object)this.id, (Object)String.valueOf(key), value);
        this.setExpire();
    }

    public Object getObject(Object key) {
        logger.debug("getObject id=[{}],key=[{}]", (Object)this.id, key);
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        HashOperations opsForHash = redisTemplate.opsForHash();
        logger.debug("redis cache " + this.id + " get key: " + key.toString());
        Object object = opsForHash.get((Object)this.id, key);
        this.setExpire();
        return object;
    }

    public Object removeObject(Object key) {
        logger.debug("removeObject id=[{}],key=[{}]", (Object)this.id, key);
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        HashOperations opsForHash = redisTemplate.opsForHash();
        opsForHash.delete((Object)this.id, new Object[]{key});
        this.setExpire();
        return null;
    }

    public void clear() {
        logger.debug("clear id=[{}]", (Object)this.id);
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        redisTemplate.execute(connection -> {
            redisTemplate.delete((Object)this.id);
            this.setExpire();
            return null;
        });
    }

    public int getSize() {
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        HashOperations opsForHash = redisTemplate.opsForHash();
        Long size = opsForHash.size((Object)this.id);
        return size.intValue();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    private RedisTemplate<String, Object> getRedisTemplate() {
        if (this.redisTemplate == null) {
            this.redisTemplate = (RedisTemplate)ApplicationContextHolder.getBean(REDIS_TEMPLATE_NAME);
        }
        return this.redisTemplate;
    }

    public void setExpire() {
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        redisTemplate.expire((Object)this.id, 120L, TimeUnit.MINUTES);
    }
}

