/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.controller;

import cn.xuqiudong.common.base.lookup.Lookup;
import cn.xuqiudong.common.base.tool.Tools;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.web.util.WebUtils;

public abstract class BaseConsoleController {
    public static final String SESSION_KEY_SUFFIX_LOOKUP = "lookup";

    protected Lookup getLookup(Lookup defaultLookup) throws IllegalStateException {
        String lookupKey = this.getClass().getName() + "." + SESSION_KEY_SUFFIX_LOOKUP;
        Lookup lookup = (Lookup)this.getSessionAttribute(lookupKey);
        if (lookup == null) {
            lookup = defaultLookup;
            this.setSessionAttribute(lookupKey, lookup);
        }
        return lookup;
    }

    protected Lookup getLookup(String prefix, Lookup defaultLookup) throws IllegalStateException {
        String lookupKey = this.getClass().getName() + "." + SESSION_KEY_SUFFIX_LOOKUP + prefix;
        Lookup lookup = (Lookup)this.getSessionAttribute(lookupKey);
        if (lookup == null) {
            lookup = defaultLookup;
            this.setSessionAttribute(lookupKey, lookup);
        }
        return lookup;
    }

    protected void setLookup(Lookup lookup) {
        this.setSessionAttribute(this.getClass().getName() + "." + SESSION_KEY_SUFFIX_LOOKUP, lookup);
    }

    protected void setLookup(Lookup lookup, String prefix) {
        this.setSessionAttribute(this.getClass().getName() + "." + SESSION_KEY_SUFFIX_LOOKUP + prefix, lookup);
    }

    protected HttpSession currentSession() {
        return Tools.currentSession();
    }

    protected void setSessionAttribute(String key, Object obj) throws IllegalStateException {
        WebUtils.setSessionAttribute((HttpServletRequest)Tools.currentRequest(), (String)key, (Object)obj);
    }

    protected <T> T getSessionAttribute(String key) throws IllegalStateException {
        return (T)WebUtils.getSessionAttribute((HttpServletRequest)Tools.currentRequest(), (String)key);
    }

    protected <T> T getOrCreateSessionAttribute(String key, Class<T> clazz) throws IllegalStateException {
        HttpSession session = Tools.currentSession();
        if (session == null) {
            return null;
        }
        return (T)BaseConsoleController.getOrCreateSessionAttribute(session, key, clazz);
    }

    private static Object getOrCreateSessionAttribute(HttpSession session, String name, Class<?> clazz) throws IllegalArgumentException {
        Object sessionObject = session.getAttribute(name);
        if (sessionObject == null) {
            try {
                sessionObject = clazz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("Could not instantiate class [" + clazz.getName() + "] for session attribute '" + name + "': " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Could not access default constructor of class [" + clazz.getName() + "] for session attribute '" + name + "': " + ex.getMessage());
            }
            session.setAttribute(name, sessionObject);
        }
        return sessionObject;
    }
}

