/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.controller;

import cn.xuqiudong.common.base.lookup.Lookup;
import cn.xuqiudong.common.base.model.BaseEntity;
import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.common.base.model.PageInfo;
import cn.xuqiudong.common.base.service.BaseService;
import cn.xuqiudong.common.base.tool.HibernateValidatorUtils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class BaseController<S extends BaseService<?, T>, T extends BaseEntity> {
    @Autowired
    protected S service;
    @Resource
    protected HttpServletRequest request;

    protected void validateModel(Object model) {
        HibernateValidatorUtils.validate(model);
    }

    @GetMapping(value={"list"})
    public BaseResponse<?> list(T lookup) {
        PageInfo list = ((BaseService)this.service).page((Lookup)lookup);
        return BaseResponse.success(list);
    }

    @PostMapping(value={"/save"})
    public BaseResponse<?> save(T entity) {
        ((BaseService)this.service).save(entity);
        return BaseResponse.success(entity);
    }

    @GetMapping(value={"/detail"})
    public BaseResponse<?> detail(Integer id) {
        Object entity = ((BaseService)this.service).findById(id);
        return BaseResponse.success(entity);
    }

    @PostMapping(value={"/delete"})
    public BaseResponse<?> delete(int id) {
        ((BaseService)this.service).delete(id);
        return BaseResponse.success();
    }

    @PostMapping(value={"/batchDelete"})
    public BaseResponse<?> delete(@RequestParam(value="ids[]") int[] ids) {
        ((BaseService)this.service).delete(ids);
        return BaseResponse.success();
    }

    @PostMapping(value={"/check"})
    public BaseResponse<?> check(Integer id, @RequestParam(defaultValue="name") String column, String value) {
        boolean ok = ((BaseService)this.service).checkNotRepeat(id, value, column);
        return BaseResponse.success(ok);
    }
}

