/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.craw;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlConnect {
    public static final String CONTENT_TYPE_KEY = "Content-Type";
    public static final String ACCEPT_KEY = "Accept";
    public static final String CONTENT_TYPE_VALUE_JSON = "application/json;charset=UTF-8";
    private final Logger logger = LoggerFactory.getLogger(CrawlConnect.class);
    private Connection connection;

    public static CrawlConnect build(String url) {
        return new CrawlConnect(url);
    }

    public CrawlConnect validateTlsCertificates() {
        this.connection.sslSocketFactory(this.socketFactory());
        return this;
    }

    public CrawlConnect(Connection connection) {
        this.connection = connection;
    }

    private SSLSocketFactory socketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to create a SSL socket factory");
        }
    }

    public CrawlConnect(String url) {
        this.connection = Jsoup.connect((String)url).ignoreContentType(true).timeout(30000);
    }

    public CrawlConnect url(String url) {
        this.connection.url(url);
        return this;
    }

    public CrawlConnect setTimeout(int millis) {
        this.connection.timeout(millis);
        return this;
    }

    public CrawlConnect url(URL url) {
        this.connection.url(url);
        return this;
    }

    public CrawlConnect cookie(String name, String value) {
        this.connection.cookie(name, value);
        return this;
    }

    public CrawlConnect cookie(Map<String, String> cookies) {
        this.connection.cookies(cookies);
        return this;
    }

    public CrawlConnect data(String ... keyvals) {
        this.connection.data(keyvals);
        return this;
    }

    public CrawlConnect data(String key, String value) {
        this.connection.data(key, value);
        return this;
    }

    public CrawlConnect data(String key, String filename, InputStream in) {
        this.connection.data(key, filename, in);
        return this;
    }

    public CrawlConnect requestBody(String body) {
        this.connection.requestBody(body);
        return this;
    }

    public Connection.Response execute() throws IOException {
        return this.connection.execute();
    }

    public CrawlConnect followRedirects(boolean followRedirects) {
        this.connection.followRedirects(followRedirects);
        return this;
    }

    public Document getDocument() throws IOException {
        return this.connection.get();
    }

    public String getHtml() throws IOException {
        return this.getDocument().html();
    }

    public String getBodyText() throws IOException {
        return this.getDocument().body().text();
    }

    public CrawlConnect header(String key, String value) {
        this.connection.header(key, value);
        return this;
    }

    public CrawlConnect header(Map<String, String> headers) {
        if (headers != null) {
            this.connection.headers(headers);
        }
        return this;
    }

    public CrawlConnect requestJson() {
        this.connection.header(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE_JSON);
        this.connection.header(ACCEPT_KEY, CONTENT_TYPE_VALUE_JSON);
        return this;
    }

    public CrawlConnect maxBodySize(int bytes) {
        this.connection.maxBodySize(bytes);
        return this;
    }

    public CrawlConnect method(Connection.Method method) {
        this.connection.method(method);
        return this;
    }

    public CrawlConnect parser(Parser parser) {
        this.connection.parser(parser);
        return this;
    }

    public Document postDocument() throws IOException {
        return this.connection.post();
    }

    public String postHtml() throws IOException {
        return this.postDocument().html();
    }

    public String postBodyText() throws IOException {
        return this.postDocument().body().text();
    }

    public CrawlConnect postDataCharset(String charset) {
        this.connection.postDataCharset(charset);
        return this;
    }

    public Connection.Request request() {
        return this.connection.request();
    }

    public Connection.Response response() {
        return this.connection.response();
    }

    public void downFile(String path, String fileName) throws IOException {
        this.logger.info("\u4e0b\u8f7d\u6587\u4ef6 \u5230\u672c\u5730{}{}", (Object)path, (Object)fileName);
        Connection.Response response = this.execute();
        File file = this.getFileByPathAndName(path, fileName);
        FileOutputStream out = new FileOutputStream(file);
        out.write(response.bodyAsBytes());
        out.close();
    }

    private File getFileByPathAndName(String path, String fileName) {
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(path, fileName);
    }
}

