/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.handler.thymeleaf.util;

import cn.xuqiudong.common.base.tool.ApplicationContextHolder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class BaseThymeleafConversionHandler {
    private static final Logger logger = LoggerFactory.getLogger(BaseThymeleafConversionHandler.class);
    private static final Map<String, BaseThymeleafConversionHandler> CONVERSION_HANDLER_HASH_MAP = new HashMap<String, BaseThymeleafConversionHandler>();

    protected abstract ConversionType type();

    protected abstract String convert(String var1);

    public static String convert(String content, String type) {
        BaseThymeleafConversionHandler handler = BaseThymeleafConversionHandler.getSubAppendJsonHandlerMap().get(type);
        if (handler == null) {
            logger.info("\u8bf7\u6ce8\u518c{}\u7c7b\u578b\u7684BaseThymeleafConversionHandler\u5904\u7406\u7c7b\u5230spring", (Object)type);
            return content;
        }
        return handler.convert(content);
    }

    public static Map<String, BaseThymeleafConversionHandler> getSubAppendJsonHandlerMap() {
        if (CONVERSION_HANDLER_HASH_MAP.size() > 0) {
            return CONVERSION_HANDLER_HASH_MAP;
        }
        ApplicationContext applicationContext = ApplicationContextHolder.getApplicationContext();
        if (applicationContext == null) {
            logger.info("\u65e0\u6cd5\u4eceApplicationContextHolder\u4e2d\u83b7\u53d6ApplicationContext");
            return CONVERSION_HANDLER_HASH_MAP;
        }
        Map beansOfType = applicationContext.getBeansOfType(BaseThymeleafConversionHandler.class);
        if (beansOfType != null) {
            beansOfType.forEach((k, v) -> CONVERSION_HANDLER_HASH_MAP.put(v.type().type(), (BaseThymeleafConversionHandler)v));
        }
        return CONVERSION_HANDLER_HASH_MAP;
    }

    public static interface ConversionType {
        public String type();
    }
}

