/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.model;

import cn.xuqiudong.common.base.enums.ResultMsg;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaseResponse<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseResponse.class);
    private int code;
    private String msg;
    private T data;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> BaseResponse<T> error(ResultMsg msg) {
        return BaseResponse.error(msg.getCode(), msg.getMsg());
    }

    public static <T> BaseResponse<T> judge(boolean judge) {
        return judge ? BaseResponse.success() : BaseResponse.error();
    }

    public static <T> BaseResponse<T> success(T data) {
        return new BaseResponse<T>(0, "", data);
    }

    public static <T> BaseResponse<T> success() {
        return new BaseResponse<T>(0, "");
    }

    public static <T> BaseResponse<T> error() {
        return BaseResponse.error(999, "");
    }

    public static <T> BaseResponse<T> error(String msg) {
        return BaseResponse.error(999, msg);
    }

    public static <T> BaseResponse<T> error(int code, String msg) {
        return new BaseResponse<T>(code, msg);
    }

    public String toJson() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "{\"code\":" + this.code + ",\"msg\":\"" + this.msg + "\",\"data\":\"" + this.data + "\"}";
        }
    }

    public String toString() {
        return this.toJson();
    }

    public BaseResponse() {
    }

    private BaseResponse(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private BaseResponse(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public BaseResponse<?> appendMsg(String msg) {
        this.msg = this.msg + msg;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public BaseResponse<?> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public BaseResponse<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean isSuccess() {
        return 0 == this.code;
    }
}

