/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.service;

import cn.xuqiudong.common.base.lookup.Lookup;
import cn.xuqiudong.common.base.mapper.BaseMapper;
import cn.xuqiudong.common.base.model.BaseEntity;
import cn.xuqiudong.common.base.model.PageInfo;
import cn.xuqiudong.common.base.service.AttachmentStatusOperationServiceI;
import cn.xuqiudong.common.util.ListUtils;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseService<M extends BaseMapper<T>, T extends BaseEntity> {
    private static final int MAX_BATCH_SIZE = 1000;
    @Autowired(required=false)
    protected M mapper;
    @Autowired(required=false)
    private AttachmentStatusOperationServiceI attachmentStatusOperationService;

    protected abstract boolean hasAttachment();

    public void startPage(int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
    }

    public void setMapper(M mapper) {
        this.mapper = mapper;
    }

    public List<T> list(Lookup lookup) {
        List datas = this.mapper.list(lookup);
        return datas;
    }

    public PageInfo<T> page(Lookup lookup) {
        this.startPage(lookup.getPage(), lookup.getSize());
        List datas = this.mapper.list(lookup);
        return PageInfo.instance(datas);
    }

    public T findById(int id) {
        BaseEntity entity = (BaseEntity)this.mapper.findById(id);
        if (this.hasAttachment() && this.attachmentStatusOperationService != null) {
            this.attachmentStatusOperationService.fillAttachmentInfo(entity);
        }
        return (T)entity;
    }

    public int insert(T entity) {
        int num = this.mapper.insert(entity);
        if (this.hasAttachment() && this.attachmentStatusOperationService != null) {
            this.attachmentStatusOperationService.addAttachmentFromObj(entity);
        }
        return num;
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchInsert(List<T> list) {
        if (list == null) {
            return 0;
        }
        List partition = ListUtils.partition(list, (int)1000);
        for (List ts : partition) {
            this.mapper.batchInsert(ts);
        }
        return list.size();
    }

    public int update(T entity) {
        if (this.hasAttachment() && this.attachmentStatusOperationService != null) {
            T old = this.findById(((BaseEntity)entity).getId());
            this.attachmentStatusOperationService.handleOldAndNowAttachment(old, entity);
        }
        return this.mapper.update(entity);
    }

    public int save(T entity) {
        if (((BaseEntity)entity).getId() == null || ((BaseEntity)entity).getId() <= 0) {
            return this.insert(entity);
        }
        return this.update(entity);
    }

    public int delete(int id) {
        if (this.hasAttachment() && this.attachmentStatusOperationService != null) {
            this.attachmentStatusOperationService.deleteAttachmentFromObj(this.findById(id));
        }
        return this.delete(new int[]{id});
    }

    public int delete(int[] ids) {
        if (this.hasAttachment() && this.attachmentStatusOperationService != null) {
            this.attachmentStatusOperationService.deleteAttachmentFromObj(this.findByIds(ids));
        }
        return this.mapper.delete(ids);
    }

    public List<T> findByIds(@Param(value="ids") int[] ids) {
        return this.mapper.findByIds(ids);
    }

    public boolean checkNotRepeat(Integer id, String value, String column) {
        return this.mapper.checkNotRepeat(id, value, column);
    }
}

