/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.tool;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Tools {
    private static final String ROOT_PATH = "/";
    static ObjectMapper objectMapper = new ObjectMapper();

    public static HttpServletRequest currentRequest() {
        ServletRequestAttributes attr = Tools.getServletRequestAttributes();
        return attr.getRequest();
    }

    public static HttpServletResponse currentResponse() {
        ServletRequestAttributes attr = Tools.getServletRequestAttributes();
        return attr.getResponse();
    }

    private static ServletRequestAttributes getServletRequestAttributes() {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attr == null) {
            throw new IllegalStateException("\u5f53\u524d\u7ebf\u7a0b\u4e2d\u4e0d\u5b58\u5728 Request \u4e0a\u4e0b\u6587");
        }
        return attr;
    }

    public static HttpSession currentSession() {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attr == null) {
            return null;
        }
        return attr.getRequest().getSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJson(Object obj, HttpServletResponse response) {
        block5: {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(objectMapper.writeValueAsString(obj));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (out == null) break block5;
                out.close();
                throw new RuntimeException("Terminate here");
            }
        }
    }

    public static String getRequestUrl(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String uri = request.getRequestURI();
        int i = uri.indexOf("?");
        if (i < 0) {
            i = uri.length();
        }
        return uri.substring(contextPath.length(), i);
    }

    public static String getRootUrl(HttpServletRequest request) {
        String contextPath;
        String url = request.getRequestURL().toString();
        String uri = request.getRequestURI();
        if (uri != null && !ROOT_PATH.equals(uri) && url.indexOf(uri) > -1) {
            url = url.substring(0, url.indexOf(uri));
        }
        if (StringUtils.hasText((String)(contextPath = request.getContextPath()))) {
            return url + ROOT_PATH + contextPath;
        }
        return url;
    }

    public static String getCurrentUrl(HttpServletRequest request) {
        return request.getRequestURL() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    public static String randomUuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isAjax(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        return "XMLHttpRequest".equalsIgnoreCase(header);
    }
}

