/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.tool.evn;

import cn.xuqiudong.common.util.ApplicationPropertiesUtil;
import cn.xuqiudong.common.util.encrypt.Base62Enhance;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class DecryptEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String SALT_KEY = "decrypt.salt";
    private static final String SALT = ApplicationPropertiesUtil.getString((String)"decrypt.salt", (String)"vic.xu");
    private static final String DECRYPT_PREFIX = "dec()";
    private static final int DECRYPT_PREFIX_LENGTH = "dec()".length();
    private static Base62Enhance enhance = Base62Enhance.createInstance((String)SALT);
    private static final String DECRYPT_RESOURCE_NAME = "decryptResource";
    private Logger logger = LoggerFactory.getLogger(DecryptEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        HashMap<String, Object> replacedMap = new HashMap<String, Object>(16);
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource instanceof MapPropertySource)) continue;
            MapPropertySource ps = (MapPropertySource)propertySource;
            this.replace(ps, replacedMap);
        }
        if (!replacedMap.isEmpty()) {
            this.logger.info("{} decrypt properties  has replace !", (Object)replacedMap.size());
            propertySources.addFirst((PropertySource)new MapPropertySource(DECRYPT_RESOURCE_NAME, replacedMap));
        }
    }

    private void replace(MapPropertySource ps, Map<String, Object> replacedMap) {
        for (String name : ps.getPropertyNames()) {
            String v;
            Object value = ps.getProperty(name);
            if (value == null || (v = String.valueOf(value)).length() <= DECRYPT_PREFIX_LENGTH || !v.startsWith(DECRYPT_PREFIX)) continue;
            v = v.substring(DECRYPT_PREFIX_LENGTH);
            v = enhance.decode(v);
            replacedMap.put(name, v);
        }
    }

    public static String enc(String value) {
        return enhance.encode(value);
    }
}

