/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.transmission.base;

import cn.xuqiudong.common.base.craw.CrawlConnect;
import cn.xuqiudong.common.base.transmission.base.ApiUrl;
import cn.xuqiudong.common.base.transmission.base.BaseThirdRequest;
import cn.xuqiudong.common.base.transmission.base.ThirdRequest;
import cn.xuqiudong.common.base.transmission.log.model.ThirdLogModel;
import cn.xuqiudong.common.base.transmission.log.service.ThirdLogService;
import cn.xuqiudong.common.base.vo.BooleanWithMsg;
import cn.xuqiudong.common.util.async.AsyncOperation;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseApiService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BaseThirdRequest thirdRequest;
    protected ThirdLogService thirdLogService;
    protected AsyncOperation asyncOperation;

    public BaseApiService(BaseThirdRequest thirdRequest, ThirdLogService thirdLogService, AsyncOperation asyncOperation) {
        this.thirdRequest = thirdRequest;
        this.thirdLogService = thirdLogService;
        this.asyncOperation = asyncOperation;
    }

    public <T extends ThirdRequest> void apiAsynchronous(ApiUrl url, T data) {
        this.asyncOperation.put(() -> this.api(url, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ThirdRequest> void api(ApiUrl url, T data) {
        this.logger.info("{}\u7b2c\u4e09\u65b9\u6570\u636e\u4f20\u8f93,\u8bf7\u6c42\u63a5\u53e3\u5730\u5740{}, \u63a5\u53e3\u8bf4\u660e{}", new Object[]{this.thirdType(), url.getUrl(), url.getText()});
        String requestText = "";
        String responseText = "";
        int status = 0;
        try {
            CrawlConnect con = this.thirdRequest.con(url.getUrl());
            requestText = this.handlerRequest(url, data, con);
            BooleanWithMsg response = this.handlerResponse(url, con);
            if (response.isSuccess()) {
                status = 1;
                responseText = response.getMessage();
            }
        }
        finally {
            if (this.log()) {
                ThirdLogModel model = this.buildLogModel(requestText, responseText, data.getFid(), status);
                this.thirdLogService.insertWithTransaction(model);
            }
        }
    }

    protected abstract <T extends ThirdRequest> String handlerRequest(ApiUrl var1, T var2, CrawlConnect var3);

    protected abstract BooleanWithMsg handlerResponse(ApiUrl var1, CrawlConnect var2);

    @NotEmpty
    protected abstract String thirdType();

    protected abstract boolean log();

    protected abstract String currentUserId();

    private ThirdLogModel buildLogModel(String request, String response, String fid, int status) {
        ThirdLogModel model = new ThirdLogModel();
        model.setThird(this.thirdType());
        model.setRequest(request);
        model.setResponse(response);
        model.setCreateUserId(this.currentUserId());
        model.setStatus(status);
        model.setFid(fid);
        return model;
    }
}

