/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.transmission.log.service;

import cn.xuqiudong.common.base.transmission.log.model.ThirdLogModel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ThirdLogService {
    @Resource
    private JdbcTemplate jdbcTemplate;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void insertWithTransaction(final ThirdLogModel model) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    ThirdLogService.this.insert(model);
                }
            });
        } else {
            this.insert(model);
        }
    }

    public int insert(final ThirdLogModel model) {
        final String sql = "INSERT INTO t_stl_s_third_log (third, request, response, status,create_user_id, fid,  create_date)  VALUE(?, ?, ? , ? , ? , ?, now() )";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql, 1);
                ps.setString(1, model.getThird());
                ps.setString(2, model.getRequest());
                ps.setString(3, model.getResponse());
                ps.setInt(4, model.getStatus());
                ps.setString(5, model.getCreateUserId());
                ps.setString(6, model.getFid());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }
}

