/*
 * Decompiled with CFR 0.152.
 */
package cn.xuqiudong.common.base.web;

import cn.xuqiudong.common.base.enums.CommonMsgEnum;
import cn.xuqiudong.common.base.exception.BadParamException;
import cn.xuqiudong.common.base.exception.CommonException;
import cn.xuqiudong.common.base.exception.UnauthorizedException;
import cn.xuqiudong.common.base.model.BaseResponse;
import cn.xuqiudong.common.base.tool.Tools;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@ControllerAdvice
@ConditionalOnClass(value={HttpServletRequest.class})
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static final String ERROR_PAGE = "error/500";

    @ExceptionHandler(value={UnauthorizedException.class})
    public ModelAndView unauthorizedHandler(HttpServletRequest request, UnauthorizedException e) {
        logger.error("\u65e0\u8bbf\u95ee{}\u6743\u9650", (Object)request.getRequestURI());
        BaseResponse baseResponse = BaseResponse.error("\u65e0\u8bbf\u95ee\u6743\u9650");
        return this.createModelAndView(request, baseResponse);
    }

    @ExceptionHandler(value={CommonException.class})
    public ModelAndView commonHandler(HttpServletRequest request, CommonException e) {
        logger.error("\u901a\u7528\u5f02\u5e38", (Throwable)e);
        BaseResponse baseResponse = BaseResponse.error(e.getMessage());
        return this.createModelAndView(request, baseResponse);
    }

    @ExceptionHandler(value={BadParamException.class})
    public ModelAndView badParamHandler(HttpServletRequest request, BadParamException e) {
        logger.error("\u8bf7\u6c42\u53c2\u6570\u7ed1\u5b9a\u5f02\u5e38", (Throwable)e);
        String msg = CommonMsgEnum.PARAM_ERROR.getMsg();
        if (e.isValidated()) {
            msg = e.getMessage();
        }
        return this.createModelAndView(request, BaseResponse.error(CommonMsgEnum.PARAM_ERROR.getCode(), msg));
    }

    @ExceptionHandler(value={Exception.class})
    public ModelAndView exceptionHandler(HttpServletRequest request, Exception e) {
        logger.error("\u975e\u81ea\u5b9a\u4e49\u5f02\u5e38", (Throwable)e);
        BaseResponse baseResponse = BaseResponse.error(e.getMessage());
        return this.createModelAndView(request, baseResponse);
    }

    private ModelAndView createModelAndView(HttpServletRequest request, BaseResponse<?> baseResponse) {
        boolean isAjax = Tools.isAjax(request);
        if (isAjax) {
            ModelAndView modelAndView = new ModelAndView((View)new MappingJackson2JsonView());
            modelAndView.addObject(baseResponse);
            return modelAndView;
        }
        ModelAndView modelAndView = new ModelAndView(ERROR_PAGE);
        modelAndView.addObject("msg", (Object)baseResponse.getMsg());
        modelAndView.addObject("code", (Object)baseResponse.getCode());
        return modelAndView;
    }
}

