/*
 * Decompiled with CFR 0.152.
 */
package com.yixian.aigenerate.client;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.yixian.aigenerate.model.AiGenerateRequest;
import com.yixian.aigenerate.model.entity.ChatCompletion;
import com.yixian.aigenerate.model.entity.Message;
import com.yixian.aigenerate.model.entity.RequestBody;
import java.util.ArrayList;
import java.util.HashMap;

public class AiGenerateClient {
    public static final String URL = "https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/chat/completions";
    private final String access_token;

    public AiGenerateClient(String accessToken) {
        this.access_token = accessToken;
    }

    public ChatCompletion doChat(AiGenerateRequest aiGenerateRequest) {
        String url = "https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/chat/completions?access_token=" + this.access_token;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        RequestBody requestBody = new RequestBody();
        Message message = new Message();
        ArrayList<Message> list = new ArrayList<Message>();
        message.setRole("user");
        message.setContent(aiGenerateRequest.getMessage());
        list.add(message);
        requestBody.setMessages(list);
        String result = ((HttpRequest)HttpRequest.post((String)url).addHeaders(headerMap)).body(JSONUtil.toJsonStr((Object)requestBody)).execute().body();
        ChatCompletion chatCompletion = (ChatCompletion)JSONUtil.parseObj((String)result).toBean(ChatCompletion.class);
        return chatCompletion;
    }

    public static void main(String[] args) {
        String accessToken = "your accessToken";
        AiGenerateClient client = new AiGenerateClient(accessToken);
        AiGenerateRequest request = new AiGenerateRequest();
        request.setMessage("\u4f60\u597d");
        ChatCompletion chatCompletion = client.doChat(request);
        System.out.println(chatCompletion.getResult());
    }
}

