/*
 * Decompiled with CFR 0.152.
 */
package com.zbinyds.easyflv.service;

import com.zbinyds.easyflv.service.Converter;
import com.zbinyds.easyflv.service.ConverterContext;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.AsyncContext;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConverter
extends Thread
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(AbstractConverter.class);
    public volatile boolean isRunning = true;
    private final String key;
    private final String url;
    private final List<AsyncContext> outs = new ArrayList<AsyncContext>();
    private byte[] headers;

    public AbstractConverter(String key, String url, AsyncContext context) {
        this.key = key;
        this.url = url;
        this.outs.add(context);
    }

    public List<AsyncContext> getOuts() {
        return this.outs;
    }

    public byte[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(byte[] headers) {
        this.headers = headers;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void addOutputStreamEntity(AsyncContext entity) {
        try {
            if (this.headers != null) {
                entity.getResponse().getOutputStream().write(this.headers);
                entity.getResponse().getOutputStream().flush();
            }
        }
        catch (Exception e) {
            log.info("error msg: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        this.outs.add(entity);
    }

    @Override
    public void exit() {
        this.isRunning = false;
        try {
            this.join();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeResponse(List<AsyncContext> outs, byte[] b) {
        Iterator<AsyncContext> it = outs.iterator();
        while (it.hasNext()) {
            AsyncContext o = it.next();
            try {
                o.getResponse().getOutputStream().write(b);
            }
            catch (Exception e) {
                log.info("\u79fb\u9664\u4e00\u4e2a\u5ba2\u6237\u7aef\u8f93\u51fa");
                it.remove();
            }
        }
    }

    protected void safeClose(FFmpegFrameGrabber grabber, FFmpegFrameRecorder recorder, ByteArrayOutputStream stream, List<AsyncContext> outs) {
        this.closeStream((Closeable)grabber);
        this.closeStream((Closeable)recorder);
        this.closeStream(stream);
        ConverterContext.remove(this.getKey());
        outs.forEach(AsyncContext::complete);
    }
}

