/*
 * Decompiled with CFR 0.152.
 */
package com.zbinyds.easyflv.service;

import com.zbinyds.easyflv.service.Converter;
import com.zbinyds.easyflv.service.ThreadPoolExecutorMonitor;
import com.zbinyds.easyflv.service.impl.DefaultConverterThread;
import com.zbinyds.easyflv.service.impl.TranscodingConverterThread;
import com.zbinyds.easyflv.util.JavaCvUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConverterContext {
    private static final Logger log = LoggerFactory.getLogger(ConverterContext.class);
    private static final Map<String, Converter> CONVERTER_BUFFER = new ConcurrentHashMap<String, Converter>(128);
    private static final ThreadPoolExecutor CONVERT_POOL = new ThreadPoolExecutorMonitor(10, 10, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), ThreadPoolExecutorMonitor.monitorThreadFactory("flv"), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());

    public static Converter getConverter(String key) {
        return CONVERTER_BUFFER.get(key);
    }

    public static void register(String key, Converter converter) {
        CONVERTER_BUFFER.put(key, converter);
    }

    public static void remove(String key) {
        CONVERTER_BUFFER.remove(key);
    }

    public static Map<String, Converter> dumpAll() {
        return CONVERTER_BUFFER;
    }

    public static Converter generateAndRunning(String url, String key, AsyncContext context) {
        try {
            FFmpegFrameGrabber grabber = JavaCvUtil.createGrabber(url);
            grabber.start();
            if (27 == grabber.getVideoCodec() && (grabber.getAudioChannels() == 0 || 86018 == grabber.getAudioCodec())) {
                DefaultConverterThread defaultConverterThread = new DefaultConverterThread(key, url, context, grabber);
                CONVERT_POOL.execute(defaultConverterThread);
                return defaultConverterThread;
            }
            TranscodingConverterThread transcodingConverterThread = new TranscodingConverterThread(key, url, context, grabber);
            CONVERT_POOL.execute(transcodingConverterThread);
            return transcodingConverterThread;
        }
        catch (FFmpegFrameGrabber.Exception e) {
            log.error("\u8fd0\u884c\u6293\u56fe\u5668FFmpegFrameGrabber\u5931\u8d25, error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        catch (RejectedExecutionException e) {
            log.error("\u7ebf\u7a0b\u6c60\u5df2\u8fbe\u4e0a\u9650\u62d2\u7edd\u6267\u884c, msg: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        catch (Exception e) {
            log.error("\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

