/*
 * Decompiled with CFR 0.152.
 */
package com.zbinyds.easyflv.service;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ThreadPoolExecutorMonitor
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolExecutorMonitor.class);
    private static final InheritableThreadLocal<Long> EXECUTE_TIMER_MONITOR = new InheritableThreadLocal();
    private final String poolName;

    public ThreadPoolExecutorMonitor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactoryMonitor threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.poolName = threadFactory.getNamePrefix();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        long cost = System.currentTimeMillis() - (Long)EXECUTE_TIMER_MONITOR.get();
        log.info("[{}]: \u4efb\u52a1\u8017\u65f6: {} ms, \u5f53\u524d\u7ebf\u7a0b\u6570: {}, \u6838\u5fc3\u7ebf\u7a0b\u6570: {}, \u6267\u884c\u7684\u4efb\u52a1\u6570\u91cf: {}, \u5df2\u5b8c\u6210\u4efb\u52a1\u6570\u91cf: {}, \u4efb\u52a1\u603b\u6570: {}, \u961f\u5217\u91cc\u7f13\u5b58\u7684\u4efb\u52a1\u6570\u91cf: {}, \u6c60\u4e2d\u5b58\u5728\u7684\u6700\u5927\u7ebf\u7a0b\u6570: {}, \u6700\u5927\u5141\u8bb8\u7684\u7ebf\u7a0b\u6570: {},  \u7ebf\u7a0b\u7a7a\u95f2\u65f6\u95f4: {}, \u7ebf\u7a0b\u6c60\u662f\u5426\u5173\u95ed: {}, \u7ebf\u7a0b\u6c60\u662f\u5426\u7ec8\u6b62: {}", new Object[]{this.poolName, cost, this.getPoolSize(), this.getCorePoolSize(), this.getActiveCount(), this.getCompletedTaskCount(), this.getTaskCount(), this.getQueue().size(), this.getLargestPoolSize(), this.getMaximumPoolSize(), this.getKeepAliveTime(TimeUnit.MILLISECONDS), this.isShutdown(), this.isTerminated()});
        EXECUTE_TIMER_MONITOR.remove();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        EXECUTE_TIMER_MONITOR.set(System.currentTimeMillis());
    }

    @Override
    public List<Runnable> shutdownNow() {
        log.info("[{}] \u7acb\u5373\u5173\u95ed\u7ebf\u7a0b\u6c60\uff0c\u5df2\u6267\u884c\u4efb\u52a1: {}, \u6b63\u5728\u6267\u884c\u4efb\u52a1: {}, \u672a\u6267\u884c\u4efb\u52a1\u6570\u91cf: {}", new Object[]{this.poolName, this.getCompletedTaskCount(), this.getActiveCount(), this.getQueue().size()});
        return super.shutdownNow();
    }

    @Override
    public void shutdown() {
        log.info("[{}] \u5173\u95ed\u7ebf\u7a0b\u6c60\uff0c\u5df2\u6267\u884c\u4efb\u52a1: {}, \u6b63\u5728\u6267\u884c\u4efb\u52a1: {}, \u672a\u6267\u884c\u4efb\u52a1\u6570\u91cf: {}", new Object[]{this.poolName, this.getCompletedTaskCount(), this.getActiveCount(), this.getQueue().size()});
        super.shutdown();
    }

    public static ThreadFactoryMonitor monitorThreadFactory() {
        return ThreadPoolExecutorMonitor.monitorThreadFactory(null);
    }

    public static ThreadFactoryMonitor monitorThreadFactory(String poolName) {
        if (!StringUtils.hasText((String)poolName)) {
            log.warn("poolName is null, use default name: {}", (Object)poolName);
            poolName = "monitor";
        }
        return new ThreadFactoryMonitor(poolName);
    }

    private static class ThreadFactoryMonitor
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        ThreadFactoryMonitor(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "-" + poolName + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        public String getNamePrefix() {
            return this.namePrefix;
        }
    }
}

