/*
 * Decompiled with CFR 0.152.
 */
package com.zbinyds.easyflv.service.helper.impl;

import com.zbinyds.easyflv.service.Converter;
import com.zbinyds.easyflv.service.ConverterContext;
import com.zbinyds.easyflv.service.helper.FlvHelper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Service;

@Service
public class FlvHelperImpl
implements FlvHelper,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(FlvHelperImpl.class);
    private static final String CHECK_MATCH = "^(rtsp|rtmp)://.*";

    public void destroy() {
        log.debug("\u6b63\u5728\u9500\u6bc1Converter\u5b9e\u4f8b");
        ConverterContext.dumpAll().forEach((key, converter) -> converter.exit());
    }

    @Override
    public void open(String url, HttpServletRequest request, HttpServletResponse response) {
        String key = this.md5(url);
        if (null == key || !FlvHelperImpl.isValid(url)) {
            log.error("url\u4e0d\u5408\u6cd5");
            response.setStatus(404);
            return;
        }
        AsyncContext context = request.startAsync();
        context.setTimeout(0L);
        Optional.ofNullable(ConverterContext.getConverter(key)).ifPresentOrElse(converter -> {
            converter.addOutputStreamEntity(context);
            this.afterSuccessConvert(response);
        }, () -> {
            Converter newConverter = ConverterContext.generateAndRunning(url, key, context);
            if (null == newConverter) {
                this.afterFailConvert(response, context);
                return;
            }
            ConverterContext.register(key, newConverter);
            this.afterSuccessConvert(response);
        });
    }

    public void afterSuccessConvert(HttpServletResponse response) {
        response.setContentType("video/x-flv");
        response.setHeader("Connection", "keep-alive");
        response.setStatus(200);
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void afterFailConvert(HttpServletResponse response, AsyncContext context) {
        context.complete();
        response.setStatus(403);
    }

    private static boolean isValid(String url) {
        return url.matches(CHECK_MATCH);
    }
}

