/*
 * Decompiled with CFR 0.152.
 */
package com.zbinyds.easyflv.service.impl;

import com.zbinyds.easyflv.service.AbstractConverter;
import com.zbinyds.easyflv.util.JavaCvUtil;
import java.io.ByteArrayOutputStream;
import javax.servlet.AsyncContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConverterThread
extends AbstractConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultConverterThread.class);
    private final FFmpegFrameGrabber grabber;
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();

    public DefaultConverterThread(String key, String url, AsyncContext context, FFmpegFrameGrabber grabber) {
        super(key, url, context);
        this.grabber = grabber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FFmpegFrameRecorder recorder = null;
        try {
            log.info("url:[{}], key:[{}] DefaultConverterThread start", (Object)super.getUrl(), (Object)super.getKey());
            avutil.av_log_set_level((int)16);
            recorder = JavaCvUtil.createRecorder(this.stream, this.grabber);
            recorder.start(this.grabber.getFormatContext());
            if (super.getHeaders() == null) {
                super.setHeaders(this.stream.toByteArray());
                this.stream.reset();
                this.writeResponse(super.getOuts(), super.getHeaders());
            }
            int nullNumber = 0;
            while (this.isRunning) {
                AVPacket k = this.grabber.grabPacket();
                if (k != null) {
                    try {
                        recorder.recordPacket(k);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.stream.size() > 0) {
                        if (super.getOuts().isEmpty()) {
                            log.info("\u6ca1\u6709\u8f93\u51fa\u9000\u51fa");
                            break;
                        }
                        byte[] b = this.stream.toByteArray();
                        this.stream.reset();
                        this.writeResponse(super.getOuts(), b);
                    }
                    avcodec.av_packet_unref((AVPacket)k);
                } else {
                    log.info("\u6293\u5305\u7b2c{}\u6b21\u5931\u8d25, \u6b63\u5728\u91cd\u65b0\u5c1d\u8bd5\u8f6c\u7801", (Object)(++nullNumber));
                    if (nullNumber > 50) {
                        log.info("\u6293\u5305\u5931\u8d25\u8fbe50\u6b21\u4e0a\u9650, \u53ef\u80fd\u7531\u4e8e\u7f51\u7edc\u6ce2\u52a8, \u8f6c\u7801\u5668\u505c\u6b62\u8f6c\u7801");
                        break;
                    }
                }
                Thread.sleep(5L);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            log.info("url:[{}], key:[{}] DefaultConverter exit", (Object)super.getUrl(), (Object)super.getKey());
            this.safeClose(this.grabber, recorder, this.stream, super.getOuts());
        }
    }
}

