/*
 * Decompiled with CFR 0.152.
 */
package com.zbinyds.easyflv.service.impl;

import com.zbinyds.easyflv.service.AbstractConverter;
import com.zbinyds.easyflv.util.JavaCvUtil;
import java.io.ByteArrayOutputStream;
import javax.servlet.AsyncContext;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscodingConverterThread
extends AbstractConverter {
    private static final Logger log = LoggerFactory.getLogger(TranscodingConverterThread.class);
    private final FFmpegFrameGrabber grabber;
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();

    public TranscodingConverterThread(String key, String url, AsyncContext context, FFmpegFrameGrabber grabber) {
        super(key, url, context);
        this.grabber = grabber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block16: {
            FFmpegFrameRecorder recorder = null;
            try {
                log.info("url:[{}], key:[{}] TranscodingConverterThread start", (Object)super.getUrl(), (Object)super.getKey());
                avutil.av_log_set_level((int)16);
                if (this.grabber.getImageWidth() > 1920) {
                    this.grabber.setImageWidth(1920);
                }
                if (this.grabber.getImageHeight() > 1080) {
                    this.grabber.setImageHeight(1080);
                }
                recorder = JavaCvUtil.createRecorder(this.stream, this.grabber);
                recorder.setGopSize(50);
                recorder.start();
                if (super.getHeaders() == null) {
                    super.setHeaders(this.stream.toByteArray());
                    this.stream.reset();
                    this.writeResponse(super.getOuts(), super.getHeaders());
                }
                int nullNumber = 0;
                while (this.isRunning) {
                    Frame f = this.grabber.grab();
                    if (f != null) {
                        try {
                            recorder.record(f);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.stream.size() > 0) {
                            if (super.getOuts().isEmpty()) {
                                log.info("\u6ca1\u6709\u8f93\u51fa\u9000\u51fa");
                                break;
                            }
                            byte[] b = this.stream.toByteArray();
                            this.stream.reset();
                            this.writeResponse(super.getOuts(), b);
                        }
                    } else {
                        log.info("\u6293\u5305\u7b2c{}\u6b21\u5931\u8d25, \u6b63\u5728\u91cd\u65b0\u5c1d\u8bd5\u8f6c\u7801", (Object)(++nullNumber));
                        if (nullNumber > 50) {
                            log.info("\u6293\u5305\u5931\u8d25\u8fbe50\u6b21\u4e0a\u9650, \u53ef\u80fd\u7531\u4e8e\u7f51\u7edc\u6ce2\u52a8, \u8f6c\u7801\u5668\u505c\u6b62\u8f6c\u7801");
                            break;
                        }
                    }
                    Thread.sleep(5L);
                }
                log.info("url:[{}], key:[{}] TranscodingConverterThread exit", (Object)super.getUrl(), (Object)super.getKey());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                break block16;
            }
            finally {
                log.info("url:[{}], key:[{}] TranscodingConverterThread exit", (Object)super.getUrl(), (Object)super.getKey());
                this.safeClose(this.grabber, recorder, this.stream, super.getOuts());
            }
            this.safeClose(this.grabber, recorder, this.stream, super.getOuts());
        }
    }
}

