package cn.zcltd.http.response;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * http请求返回结果
 */
public class JsonHttpResponseResult extends StringHttpResponseResult {
    protected JSONObject responseJson;

    public JsonHttpResponseResult(String responseStr, Map<String, String> headerMap) {
        super(responseStr);
        this.getHeaderMap().putAll(headerMap);
        this.responseJson = JSONObject.parseObject(responseStr);
    }

    public JsonHttpResponseResult(StringHttpResponseResult stringHttpResponseResult) {
        this(stringHttpResponseResult.getResponseStr(), stringHttpResponseResult.getHeaderMap());
    }

    public JSONObject getResponseJson() {
        return responseJson;
    }

    @Override
    public String toString() {
        return "JsonHttpResponseResult{" +
                "headerMap=" + headerMap +
                "responseJson='" + responseStr + '\'' +
                '}';
    }
}