package cn.zcltd.http.task;

import cn.zcltd.http.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskBTGHttpRequesterTimeoutClean extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TaskBTGHttpRequesterTimeoutClean.class);

    private static TaskBTGHttpRequesterTimeoutClean instance = new TaskBTGHttpRequesterTimeoutClean();

    public static TaskBTGHttpRequesterTimeoutClean getInstance() {
        return instance;
    }

    private TaskBTGHttpRequesterTimeoutClean() {
        this.setName("BTG-TaskBTGHttpRequesterTimeoutClean");
    }

    @Override
    public void run() {
        while (true) {
            work();
            try {
                Thread.sleep(HttpUtil.getMaxClearTimeoutSeconds() * 1000);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    /**
     * 删除指定保留天数之前的系统日志
     */
    public void work() {
        try {
            log.debug("Task:clean http requester timeout start...");
            HttpUtil.clearTimeout();
            log.debug("Task:clean http requester timeout success...");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}
