package cn.zcltd.http.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * http请求返回结果
 */
public abstract class HttpResponseResult {
    protected Map<String, String> headerMap = new HashMap<>();
    protected String charset = "UTF-8";

    public HttpResponseResult() {

    }

    public String getCharset() {
        return charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void addHeader(String key, String value) {
        headerMap.put(key, value);
    }

    public void addHeaders(Map<String, String> headers) {
        headerMap.putAll(headers);
    }

    public String getHeader(String headerName) {
        return headerMap.get(headerName);
    }

    public Map<String, String> getHeaderMap() {
        return headerMap;
    }

    public abstract InputStream getResponseBody() throws IOException, UnsupportedOperationException;

    @Override
    public String toString() {
        return "HttpResponseResult{" +
                "headerMap=" + headerMap +
                '}';
    }
}