package cn.zcltd.http.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * http请求返回结果
 */
public class ByteHttpResponseResult extends HttpResponseResult {
    protected byte[] responseByte;

    public ByteHttpResponseResult(byte[] responseByte) {
        this.responseByte = responseByte;
    }

    @Override
    public InputStream getResponseBody() throws IOException, UnsupportedOperationException {
        return new ByteArrayInputStream(responseByte);
    }

    public byte[] getResponseByte() {
        return responseByte;
    }

    @Override
    public String toString() {
        return "JsonHttpResponseResult{" +
                "headerMap=" + headerMap +
                "responseJson='" + responseByte.length + '\'' +
                '}';
    }
}