package cn.zcltd.http.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * http请求返回结果
 */
public class StringHttpResponseResult extends HttpResponseResult {
    protected String responseStr;

    public StringHttpResponseResult(String responseStr) {
        this.responseStr = responseStr;
    }

    public String getResponseStr() {
        return responseStr;
    }

    @Override
    public InputStream getResponseBody() throws IOException {
        return new ByteArrayInputStream(responseStr.getBytes(this.charset));
    }

    @Override
    public String toString() {
        return "StringHttpResponseResult{" +
                "headerMap=" + headerMap +
                "responseStr='" + responseStr + '\'' +
                '}';
    }
}