package cn.zcltd.http.response;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 返回字符串
 */
public class StringHttpResponseHandler extends HttpResponseHandler {

    public StringHttpResponseHandler() {
        super();
    }

    public StringHttpResponseHandler(String charset) {
        super(charset);
    }

    @Override
    public StringHttpResponseResult handler(HttpUriRequest request, HttpResponse response) throws Exception {
        String responseStr = null;
        HttpEntity respEntity = response.getEntity();
        if (null != respEntity) {
            responseStr = EntityUtils.toString(response.getEntity(), this.charset);
        }
        StringHttpResponseResult result = new StringHttpResponseResult(responseStr);
        result.setStatus(response.getStatusLine().getStatusCode());
        Header[] headers = response.getAllHeaders();
        if (headers != null && headers.length > 0) {
            for (Header header : headers) {
                result.addHeader(header.getName(), header.getValue());
            }
        }
        print(request, response, result);
        return result;
    }

    public void print(HttpUriRequest request, HttpResponse response, StringHttpResponseResult stringHttpResponseResult) {
        try {
            StringBuilder resultSb = new StringBuilder();

            resultSb.append(String.format("URL:%s\n", request.getURI().toURL()));

            resultSb.append(String.format("Method:%s\n", request.getMethod()));

            Header[] allHeaders = request.getAllHeaders();
            resultSb.append(String.format("RequestHeaders:\n"));
            for (Header allHeader : allHeaders) {
                resultSb.append(String.format("\t%s:%s\n", allHeader.getName(), allHeader.getValue()));
            }

            resultSb.append(String.format("ResponseCode:%s\n", response.getStatusLine().getStatusCode()));

            resultSb.append(String.format("ResponseHeaders:\n"));
            for (Header allHeader : response.getAllHeaders()) {
                resultSb.append(String.format("\t%s:%s\n", allHeader.getName(), allHeader.getValue()));
            }

            resultSb.append(String.format("ResponseEntity:\n"));
            resultSb.append(stringHttpResponseResult.getResponseStr());

            if (printLog) {
                log.debug(resultSb.toString());
            }

            if (printFile) {
                File dir = new File(reqFilePath);
                if (!dir.exists() || !dir.isDirectory()) {
                    boolean isSuccess = dir.mkdirs();
                    if (!isSuccess) {
                        throw new RuntimeException("directory does not exist and create the failure," + dir.getCanonicalPath());
                    }
                }

                String timestampStr = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                URI reqUri = request.getURI();
                String reqInfo = request.getMethod() + "-" + reqUri.getScheme() + "-" + reqUri.getHost() + "-" + reqUri.getPort();
                String fileName = timestampStr + "-" + reqInfo + ".req";
                File file = new File(reqFilePath + fileName);
                FileOutputStream outputStream = new FileOutputStream(file);
                outputStream.write(resultSb.toString().getBytes());
                outputStream.close();
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}