package cn.zcltd.http.response;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

/**
 * 返回字符串
 */
public class StringHttpResponseHandler extends HttpResponseHandler {

    private StringHttpResponseResult responseResult;

    public StringHttpResponseHandler() {

    }

    @Override
    public StringHttpResponseResult handler(HttpUriRequest request, HttpResponse response) throws Exception {
        HttpResponseResult resultBase = super.handler(request, response);
        responseResult = new StringHttpResponseResult(resultBase);
        return responseResult;
    }

    @Override
    public String buildPrintBody() {
        return responseResult.getResponseStr();
    }
}