package cn.zcltd.http.response;

import cn.zcltd.btg.sutil.EmptyUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public abstract class HttpResponseHandler {
    private HttpResponseResult httpResponseResult;

    public HttpResponseHandler() {

    }

    /**
     * response处理程序
     *
     * @param request  request
     * @param response response
     * @return 处理后结果
     * @throws Exception 异常
     */
    public HttpResponseResult handler(HttpUriRequest request, HttpResponse response) throws Exception {
        byte[] responseByte = null;
        HttpEntity respEntity = response.getEntity();
        if (EmptyUtil.isNotEmpty(respEntity)) {
            responseByte = EntityUtils.toByteArray(response.getEntity());
        }
        httpResponseResult = new HttpResponseResult(responseByte);
        httpResponseResult.setStatus(response.getStatusLine().getStatusCode());
        Header[] headers = response.getAllHeaders();
        if (headers != null && headers.length > 0) {
            for (Header header : headers) {
                httpResponseResult.addHeader(header.getName(), header.getValue());
            }
        }
        return httpResponseResult;
    }

    public String buildPrintBody() {
        return "B]" + httpResponseResult.getResponseByte().length;
    }
}