package cn.zcltd.btg.httpsession.servlet;

/**
 * 上下文：保存sessionId
 */
public class SessionIdContext {
    private static ThreadLocal<String> currentSessionId = new ThreadLocal<>();

    /**
     * 获取当前线程sessionId
     *
     * @return sessionId
     */
    public static String getSessionId() {
        return currentSessionId.get();
    }

    /**
     * 设置当前线程sessionId
     *
     * @param sessionId sessionId
     */
    public static void setSessionId(String sessionId) {
        currentSessionId.set(sessionId);
    }
}
