package cn.zcltd.btg.httpsession.task;

import cn.zcltd.btg.httpsession.kit.SessionKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskBTGSessionTimeoutClean extends Thread {
    private static final Logger log = LoggerFactory.getLogger(TaskBTGSessionTimeoutClean.class);

    private static TaskBTGSessionTimeoutClean instance = new TaskBTGSessionTimeoutClean();

    public static TaskBTGSessionTimeoutClean getInstance() {
        return instance;
    }

    private TaskBTGSessionTimeoutClean() {
        this.setName("BTG-TaskBTGSessionTimeoutClean");
    }

    @Override
    public void run() {
        while (true) {
            work();
            try {
                Thread.sleep(SessionKit.getMaxClearTimeoutSeconds() * 1000);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    /**
     * 删除指定保留天数之前的系统日志
     */
    public void work() {
        try {
            log.debug("Task:clean session timeout start...");
            SessionKit.clearTimeout();
            log.debug("Task:clean session timeout success...");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }
}
